/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import io.netty.channel.Channel;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

abstract class ChannelPoolTestBase {
    @Mock
    protected InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    protected DriverExecutionProfile defaultProfile;
    @Mock
    private ReconnectionPolicy reconnectionPolicy;
    @Mock
    protected ReconnectionPolicy.ReconnectionSchedule reconnectionSchedule;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    protected ChannelFactory channelFactory;
    @Mock
    protected MetricsFactory metricsFactory;
    @Mock
    protected NodeMetricUpdater nodeMetricUpdater;
    protected DefaultNode node;
    protected EventBus eventBus;
    private DefaultEventLoopGroup adminEventLoopGroup;

    ChannelPoolTestBase() {
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.adminEventLoopGroup = new DefaultEventLoopGroup(1);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminEventLoopGroup);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        this.eventBus = (EventBus)Mockito.spy((Object)new EventBus("test"));
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        Mockito.when((Object)this.context.getReconnectionPolicy()).thenReturn((Object)this.reconnectionPolicy);
        Mockito.when((Object)this.reconnectionPolicy.newNodeSchedule((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)this.reconnectionSchedule);
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofDays(1L));
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        Mockito.when((Object)this.metricsFactory.newNodeUpdater((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)this.nodeMetricUpdater);
        this.node = TestNodeFactory.newNode(1, this.context);
    }

    @After
    public void teardown() {
        this.adminEventLoopGroup.shutdownGracefully(100L, 200L, TimeUnit.MILLISECONDS);
    }

    DriverChannel newMockDriverChannel(int id) {
        DriverChannel driverChannel = (DriverChannel)Mockito.mock(DriverChannel.class);
        EventLoop adminExecutor = this.adminEventLoopGroup.next();
        Channel channel = (Channel)Mockito.mock(Channel.class);
        DefaultChannelPromise closeFuture = new DefaultChannelPromise(channel, (EventExecutor)adminExecutor);
        DefaultChannelPromise closeStartedFuture = new DefaultChannelPromise(channel, (EventExecutor)adminExecutor);
        Mockito.when((Object)driverChannel.close()).thenReturn((Object)closeFuture);
        Mockito.when((Object)driverChannel.forceClose()).thenReturn((Object)closeFuture);
        Mockito.when((Object)driverChannel.closeFuture()).thenReturn((Object)closeFuture);
        Mockito.when((Object)driverChannel.closeStartedFuture()).thenReturn((Object)closeStartedFuture);
        Mockito.when((Object)driverChannel.setKeyspace((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class))).thenReturn((Object)adminExecutor.newSucceededFuture(null));
        Mockito.when((Object)driverChannel.toString()).thenReturn((Object)("channel" + id));
        return driverChannel;
    }

    void waitForPendingAdminTasks() {
        ScheduledFuture f = this.adminEventLoopGroup.schedule(() -> null, 5L, TimeUnit.NANOSECONDS);
        try {
            Uninterruptibles.getUninterruptibly((Future)f, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assertions.fail((String)"unexpected error", (Throwable)e.getCause());
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"timed out while waiting for admin tasks to complete", (Throwable)e);
        }
    }
}

