/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.MockChannelFactoryHelper;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolTestBase;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.Test;
import org.mockito.Mockito;

public class ChannelPoolKeyspaceTest
extends ChannelPoolTestBase {
    @Test
    public void should_switch_keyspace_on_existing_channels() throws Exception {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).build();
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        CqlIdentifier newKeyspace = CqlIdentifier.fromCql((String)"new_keyspace");
        CompletionStage setKeyspaceFuture = pool.setKeyspace(newKeyspace);
        this.waitForPendingAdminTasks();
        ((DriverChannel)Mockito.verify((Object)channel1)).setKeyspace(newKeyspace);
        ((DriverChannel)Mockito.verify((Object)channel2)).setKeyspace(newKeyspace);
        Assertions.assertThatStage(setKeyspaceFuture).isSuccess();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_switch_keyspace_on_pending_channels() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        CompletableFuture<DriverChannel> channel1Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node, "mock channel init failure").failure((Node)this.node, "mock channel init failure").pending((Node)this.node, channel1Future).pending((Node)this.node, channel2Future).build();
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCalls((Node)this.node, 2);
        CqlIdentifier newKeyspace = CqlIdentifier.fromCql((String)"new_keyspace");
        CompletionStage setKeyspaceFuture = pool.setKeyspace(newKeyspace);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(setKeyspaceFuture).isSuccess();
        channel1Future.complete(channel1);
        channel2Future.complete(channel2);
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        ((DriverChannel)Mockito.verify((Object)channel1)).setKeyspace(newKeyspace);
        ((DriverChannel)Mockito.verify((Object)channel2)).setKeyspace(newKeyspace);
        factoryHelper.verifyNoMoreCalls();
    }
}

