/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.SimpleReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SimpleReplicationStrategyTest {
    private static final Token TOKEN01 = new Murmur3Token(-9000000000000000000L);
    private static final Token TOKEN02 = new Murmur3Token(-8000000000000000000L);
    private static final Token TOKEN03 = new Murmur3Token(-7000000000000000000L);
    private static final Token TOKEN04 = new Murmur3Token(-6000000000000000000L);
    private static final Token TOKEN05 = new Murmur3Token(-5000000000000000000L);
    private static final Token TOKEN06 = new Murmur3Token(-4000000000000000000L);
    private static final Token TOKEN07 = new Murmur3Token(-3000000000000000000L);
    private static final Token TOKEN08 = new Murmur3Token(-2000000000000000000L);
    private static final Token TOKEN09 = new Murmur3Token(-1000000000000000000L);
    private static final Token TOKEN10 = new Murmur3Token(0L);
    private static final Token TOKEN11 = new Murmur3Token(1000000000000000000L);
    private static final Token TOKEN12 = new Murmur3Token(2000000000000000000L);
    private static final Token TOKEN13 = new Murmur3Token(3000000000000000000L);
    private static final Token TOKEN14 = new Murmur3Token(4000000000000000000L);
    private static final Token TOKEN15 = new Murmur3Token(5000000000000000000L);
    private static final Token TOKEN16 = new Murmur3Token(6000000000000000000L);
    private static final Token TOKEN17 = new Murmur3Token(7000000000000000000L);
    private static final Token TOKEN18 = new Murmur3Token(8000000000000000000L);
    private static final Token TOKEN19 = new Murmur3Token(9000000000000000000L);
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    @Mock
    private Node node3;
    @Mock
    private Node node4;
    @Mock
    private Node node5;
    @Mock
    private Node node6;

    @Test
    public void should_compute_for_simple_layout() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN06, (Object)TOKEN14, (Object)TOKEN19);
        ImmutableMap tokenToPrimary = ImmutableMap.of((Object)TOKEN01, (Object)this.node1, (Object)TOKEN06, (Object)this.node2, (Object)TOKEN14, (Object)this.node1, (Object)TOKEN19, (Object)this.node2);
        SimpleReplicationStrategy strategy = new SimpleReplicationStrategy(2);
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node2, this.node1});
    }

    @Test
    public void should_compute_when_nodes_own_consecutive_tokens() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN06, (Object)TOKEN14, (Object)TOKEN19);
        ImmutableMap tokenToPrimary = ImmutableMap.of((Object)TOKEN01, (Object)this.node1, (Object)TOKEN06, (Object)this.node1, (Object)TOKEN14, (Object)this.node2, (Object)TOKEN19, (Object)this.node2);
        SimpleReplicationStrategy strategy = new SimpleReplicationStrategy(2);
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node2, this.node1});
    }

    @Test
    public void should_compute_when_ring_unbalanced() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN06, (Object)TOKEN14, (Object)TOKEN19);
        ImmutableMap tokenToPrimary = ImmutableMap.of((Object)TOKEN01, (Object)this.node1, (Object)TOKEN06, (Object)this.node1, (Object)TOKEN14, (Object)this.node2, (Object)TOKEN19, (Object)this.node1);
        SimpleReplicationStrategy strategy = new SimpleReplicationStrategy(2);
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node1, this.node2});
    }

    @Test
    public void should_compute_when_replication_factor_is_larger_than_cluster_size() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN06, (Object)TOKEN14, (Object)TOKEN19);
        ImmutableMap tokenToPrimary = ImmutableMap.of((Object)TOKEN01, (Object)this.node1, (Object)TOKEN06, (Object)this.node2, (Object)TOKEN14, (Object)this.node1, (Object)TOKEN19, (Object)this.node2);
        SimpleReplicationStrategy strategy = new SimpleReplicationStrategy(6);
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node2, this.node1});
    }

    @Test
    public void should_compute_for_complex_layout() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN09).add((Object)TOKEN10).add((Object)TOKEN11).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN02, (Object)this.node1).put((Object)TOKEN03, (Object)this.node5).put((Object)TOKEN04, (Object)this.node3).put((Object)TOKEN05, (Object)this.node1).put((Object)TOKEN06, (Object)this.node5).put((Object)TOKEN07, (Object)this.node2).put((Object)TOKEN08, (Object)this.node6).put((Object)TOKEN09, (Object)this.node3).put((Object)TOKEN10, (Object)this.node4).put((Object)TOKEN11, (Object)this.node5).put((Object)TOKEN12, (Object)this.node4).put((Object)TOKEN13, (Object)this.node4).put((Object)TOKEN14, (Object)this.node2).put((Object)TOKEN15, (Object)this.node6).put((Object)TOKEN16, (Object)this.node3).put((Object)TOKEN17, (Object)this.node2).put((Object)TOKEN18, (Object)this.node6).build();
        SimpleReplicationStrategy strategy = new SimpleReplicationStrategy(3);
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node5, this.node3, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node6, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN09)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN10)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN11)).containsExactly((Object[])new Node[]{this.node5, this.node4, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node4, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node4, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node6, this.node3, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5});
    }
}

