/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.NetworkTopologyReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class NetworkTopologyReplicationStrategyTest {
    private static final String DC1 = "DC1";
    private static final String DC2 = "DC2";
    private static final String DC3 = "DC3";
    private static final String RACK11 = "RACK11";
    private static final String RACK12 = "RACK12";
    private static final String RACK21 = "RACK21";
    private static final String RACK22 = "RACK22";
    private static final String RACK31 = "RACK31";
    private static final Token TOKEN01 = new Murmur3Token(-9000000000000000000L);
    private static final Token TOKEN02 = new Murmur3Token(-8000000000000000000L);
    private static final Token TOKEN03 = new Murmur3Token(-7000000000000000000L);
    private static final Token TOKEN04 = new Murmur3Token(-6000000000000000000L);
    private static final Token TOKEN05 = new Murmur3Token(-5000000000000000000L);
    private static final Token TOKEN06 = new Murmur3Token(-4000000000000000000L);
    private static final Token TOKEN07 = new Murmur3Token(-3000000000000000000L);
    private static final Token TOKEN08 = new Murmur3Token(-2000000000000000000L);
    private static final Token TOKEN09 = new Murmur3Token(-1000000000000000000L);
    private static final Token TOKEN10 = new Murmur3Token(0L);
    private static final Token TOKEN11 = new Murmur3Token(1000000000000000000L);
    private static final Token TOKEN12 = new Murmur3Token(2000000000000000000L);
    private static final Token TOKEN13 = new Murmur3Token(3000000000000000000L);
    private static final Token TOKEN14 = new Murmur3Token(4000000000000000000L);
    private static final Token TOKEN15 = new Murmur3Token(5000000000000000000L);
    private static final Token TOKEN16 = new Murmur3Token(6000000000000000000L);
    private static final Token TOKEN17 = new Murmur3Token(7000000000000000000L);
    private static final Token TOKEN18 = new Murmur3Token(8000000000000000000L);
    private static final Token TOKEN19 = new Murmur3Token(9000000000000000000L);
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    @Mock
    private Node node3;
    @Mock
    private Node node4;
    @Mock
    private Node node5;
    @Mock
    private Node node6;
    @Mock
    private Node node7;
    @Mock
    private Node node8;
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;

    @Test
    public void should_compute_for_simple_layout() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN04, (Object)TOKEN14, (Object)TOKEN19);
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        ImmutableMap tokenToPrimary = ImmutableMap.of((Object)TOKEN01, (Object)this.node1, (Object)TOKEN04, (Object)this.node2, (Object)TOKEN14, (Object)this.node1, (Object)TOKEN19, (Object)this.node2);
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)"1", (Object)DC2, (Object)"1"), "test");
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node2, this.node1});
    }

    @Test
    public void should_compute_for_simple_layout_with_multiple_nodes_per_rack() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN03, (Object)TOKEN05, (Object)TOKEN07, (Object)TOKEN13, (Object)TOKEN15, (Object)TOKEN17, (Object)TOKEN19);
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC1, RACK11);
        this.locate(this.node4, DC2, RACK21);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN03, (Object)this.node2).put((Object)TOKEN05, (Object)this.node3).put((Object)TOKEN07, (Object)this.node4).put((Object)TOKEN13, (Object)this.node1).put((Object)TOKEN15, (Object)this.node2).put((Object)TOKEN17, (Object)this.node3).put((Object)TOKEN19, (Object)this.node4).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)"1", (Object)DC2, (Object)"1"), "test");
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node4, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node4, this.node1});
    }

    @Test
    public void should_compute_for_simple_layout_with_3_dcs() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN05, (Object)TOKEN09, (Object)TOKEN11, (Object)TOKEN15, (Object)TOKEN19);
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC3, RACK31);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN05, (Object)this.node2).put((Object)TOKEN09, (Object)this.node3).put((Object)TOKEN11, (Object)this.node1).put((Object)TOKEN15, (Object)this.node2).put((Object)TOKEN19, (Object)this.node3).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)"1", (Object)DC2, (Object)"1", (Object)DC3, (Object)"1"), "test");
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN09)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN11)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2});
    }

    @Test
    public void should_compute_for_unbalanced_ring() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN03, (Object)TOKEN05, (Object)TOKEN07, (Object)TOKEN09, (Object)TOKEN11, (Object)TOKEN13, (Object)TOKEN15, (Object)TOKEN17, (Object)TOKEN19);
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC1, RACK11);
        this.locate(this.node4, DC2, RACK21);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN03, (Object)this.node1).put((Object)TOKEN05, (Object)this.node2).put((Object)TOKEN07, (Object)this.node3).put((Object)TOKEN09, (Object)this.node4).put((Object)TOKEN11, (Object)this.node1).put((Object)TOKEN13, (Object)this.node1).put((Object)TOKEN15, (Object)this.node2).put((Object)TOKEN17, (Object)this.node3).put((Object)TOKEN19, (Object)this.node4).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)"2", (Object)DC2, (Object)"2"), "test");
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN09)).containsExactly((Object[])new Node[]{this.node4, this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN11)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node4, this.node1, this.node2, this.node3});
    }

    @Test
    public void should_compute_with_multiple_racks_per_dc() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN02, (Object)TOKEN03, (Object)TOKEN04, (Object)TOKEN05, (Object)TOKEN06, (Object)TOKEN07, (Object)TOKEN08, (Object)TOKEN12, (Object)TOKEN13, (Object)TOKEN14, (Object)TOKEN15, (Object[])new Token[]{TOKEN16, TOKEN17, TOKEN18, TOKEN19});
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC1, RACK12);
        this.locate(this.node4, DC2, RACK22);
        this.locate(this.node5, DC1, RACK11);
        this.locate(this.node6, DC2, RACK21);
        this.locate(this.node7, DC1, RACK12);
        this.locate(this.node8, DC2, RACK22);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN02, (Object)this.node2).put((Object)TOKEN03, (Object)this.node3).put((Object)TOKEN04, (Object)this.node4).put((Object)TOKEN05, (Object)this.node5).put((Object)TOKEN06, (Object)this.node6).put((Object)TOKEN07, (Object)this.node7).put((Object)TOKEN08, (Object)this.node8).put((Object)TOKEN12, (Object)this.node1).put((Object)TOKEN13, (Object)this.node2).put((Object)TOKEN14, (Object)this.node3).put((Object)TOKEN15, (Object)this.node4).put((Object)TOKEN16, (Object)this.node5).put((Object)TOKEN17, (Object)this.node6).put((Object)TOKEN18, (Object)this.node7).put((Object)TOKEN19, (Object)this.node8).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)"2", (Object)DC2, (Object)"2"), "test");
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node6, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node5, this.node6, this.node7, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node6, this.node7, this.node8, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node7, this.node8, this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node6, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node5, this.node6, this.node7, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node6, this.node7, this.node8, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node7, this.node8, this.node1, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node2, this.node3});
    }

    @Test
    public void should_pick_dc_replicas_in_different_racks_first() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN02, (Object)TOKEN03, (Object)TOKEN04, (Object)TOKEN05, (Object)TOKEN06, (Object)TOKEN07, (Object)TOKEN08, (Object)TOKEN12, (Object)TOKEN13, (Object)TOKEN14, (Object)TOKEN15, (Object[])new Token[]{TOKEN16, TOKEN17, TOKEN18, TOKEN19});
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC1, RACK11);
        this.locate(this.node4, DC2, RACK21);
        this.locate(this.node5, DC1, RACK12);
        this.locate(this.node6, DC2, RACK22);
        this.locate(this.node7, DC1, RACK12);
        this.locate(this.node8, DC2, RACK22);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN02, (Object)this.node2).put((Object)TOKEN03, (Object)this.node3).put((Object)TOKEN04, (Object)this.node4).put((Object)TOKEN05, (Object)this.node5).put((Object)TOKEN06, (Object)this.node6).put((Object)TOKEN07, (Object)this.node7).put((Object)TOKEN08, (Object)this.node8).put((Object)TOKEN12, (Object)this.node1).put((Object)TOKEN13, (Object)this.node2).put((Object)TOKEN14, (Object)this.node3).put((Object)TOKEN15, (Object)this.node4).put((Object)TOKEN16, (Object)this.node5).put((Object)TOKEN17, (Object)this.node6).put((Object)TOKEN18, (Object)this.node7).put((Object)TOKEN19, (Object)this.node8).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)"3", (Object)DC2, (Object)"3"), "test");
        SetMultimap replicasByToken = strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(ring.size());
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node5, this.node3, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node5, this.node6, this.node4, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node6, this.node7, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node6, this.node8, this.node1, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node5, this.node6, this.node1, this.node7, this.node2, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node6, this.node7, this.node1, this.node2, this.node8, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node7, this.node8, this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node2, this.node4, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node5, this.node3, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node5, this.node6, this.node4, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node6, this.node7, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node6, this.node8, this.node1, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node5, this.node6, this.node1, this.node7, this.node2, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node6, this.node7, this.node1, this.node2, this.node8, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node7, this.node8, this.node1, this.node2, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node2, this.node4, this.node5, this.node3});
    }

    @Test
    public void should_pick_dc_replicas_in_different_racks_first_when_nodes_own_consecutive_tokens() {
        SetMultimap<Token, Node> replicasByToken = this.computeWithDifferentRacksAndConsecutiveTokens(3);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(16);
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node7, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node7, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6, this.node4, this.node1, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6, this.node4, this.node1, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node7, this.node2, this.node6, this.node4, this.node1, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node7, this.node2, this.node6, this.node4, this.node1, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node4, this.node1, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node4, this.node1, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node8, this.node1, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node8, this.node1, this.node5, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5, this.node3, this.node2, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5, this.node3, this.node2, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node5, this.node3, this.node2, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node5, this.node3, this.node2, this.node4});
    }

    @Test
    public void should_pick_dc_replicas_in_different_racks_first_when_all_nodes_contain_all_data() {
        SetMultimap<Token, Node> replicasByToken = this.computeWithDifferentRacksAndConsecutiveTokens(4);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(16);
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3, this.node7, this.node2, this.node6, this.node4, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3, this.node7, this.node2, this.node6, this.node4, this.node8});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node7, this.node2, this.node6, this.node4, this.node8, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node7, this.node2, this.node6, this.node4, this.node8, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6, this.node4, this.node8, this.node1, this.node7, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6, this.node4, this.node8, this.node1, this.node7, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node7, this.node2, this.node6, this.node4, this.node8, this.node1, this.node3, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node7, this.node2, this.node6, this.node4, this.node8, this.node1, this.node3, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node4, this.node8, this.node1, this.node5, this.node3, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node4, this.node8, this.node1, this.node5, this.node3, this.node7});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node8, this.node1, this.node5, this.node3, this.node7, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node8, this.node1, this.node5, this.node3, this.node7, this.node2});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5, this.node3, this.node7, this.node2, this.node8, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5, this.node3, this.node7, this.node2, this.node8, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node5, this.node3, this.node7, this.node2, this.node4, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN19)).containsExactly((Object[])new Node[]{this.node8, this.node1, this.node5, this.node3, this.node7, this.node2, this.node4, this.node6});
    }

    private SetMultimap<Token, Node> computeWithDifferentRacksAndConsecutiveTokens(int replicationFactor) {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN02, (Object)TOKEN03, (Object)TOKEN04, (Object)TOKEN05, (Object)TOKEN06, (Object)TOKEN07, (Object)TOKEN08, (Object)TOKEN12, (Object)TOKEN13, (Object)TOKEN14, (Object)TOKEN15, (Object[])new Token[]{TOKEN16, TOKEN17, TOKEN18, TOKEN19});
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC1, RACK11);
        this.locate(this.node4, DC2, RACK21);
        this.locate(this.node5, DC1, RACK12);
        this.locate(this.node6, DC2, RACK22);
        this.locate(this.node7, DC1, RACK12);
        this.locate(this.node8, DC2, RACK22);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN02, (Object)this.node1).put((Object)TOKEN03, (Object)this.node3).put((Object)TOKEN04, (Object)this.node3).put((Object)TOKEN05, (Object)this.node5).put((Object)TOKEN06, (Object)this.node5).put((Object)TOKEN07, (Object)this.node7).put((Object)TOKEN08, (Object)this.node7).put((Object)TOKEN12, (Object)this.node2).put((Object)TOKEN13, (Object)this.node2).put((Object)TOKEN14, (Object)this.node4).put((Object)TOKEN15, (Object)this.node4).put((Object)TOKEN16, (Object)this.node6).put((Object)TOKEN17, (Object)this.node6).put((Object)TOKEN18, (Object)this.node8).put((Object)TOKEN19, (Object)this.node8).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)Integer.toString(replicationFactor), (Object)DC2, (Object)Integer.toString(replicationFactor)), "test");
        return strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
    }

    @Test
    public void should_compute_complex_layout() {
        SetMultimap<Token, Node> replicasByToken = this.computeComplexLayout(2);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(18);
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node5, this.node3, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node2, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node3, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node6, this.node3, this.node4, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN09)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node6});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN10)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node6, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN11)).containsExactly((Object[])new Node[]{this.node5, this.node4, this.node6, this.node3});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node3, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node3, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node3, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node6, this.node3, this.node2, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node6, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node1, this.node5});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5, this.node2});
    }

    @Test
    public void should_compute_complex_layout_with_rf_too_high() {
        SetMultimap<Token, Node> replicasByToken = this.computeComplexLayout(4);
        Assertions.assertThat((int)replicasByToken.keySet().size()).isEqualTo(18);
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN01)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN02)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node3, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN03)).containsExactly((Object[])new Node[]{this.node5, this.node3, this.node1, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN04)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node6, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN05)).containsExactly((Object[])new Node[]{this.node1, this.node5, this.node2, this.node6, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN06)).containsExactly((Object[])new Node[]{this.node5, this.node2, this.node6, this.node3, this.node4, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN07)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node3, this.node4, this.node5, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN08)).containsExactly((Object[])new Node[]{this.node6, this.node3, this.node4, this.node5, this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN09)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node6, this.node2, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN10)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node6, this.node2, this.node3, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN11)).containsExactly((Object[])new Node[]{this.node5, this.node4, this.node6, this.node2, this.node3, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN12)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node2, this.node3, this.node5, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN13)).containsExactly((Object[])new Node[]{this.node4, this.node6, this.node2, this.node3, this.node5, this.node1});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN14)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node3, this.node5, this.node1, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN15)).containsExactly((Object[])new Node[]{this.node6, this.node3, this.node2, this.node5, this.node1, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN16)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node6, this.node5, this.node1, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN17)).containsExactly((Object[])new Node[]{this.node2, this.node6, this.node1, this.node5, this.node3, this.node4});
        Assertions.assertThat((Iterable)replicasByToken.get((Object)TOKEN18)).containsExactly((Object[])new Node[]{this.node6, this.node1, this.node5, this.node3, this.node2, this.node4});
    }

    private SetMultimap<Token, Node> computeComplexLayout(int replicationFactor) {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN02, (Object)TOKEN03, (Object)TOKEN04, (Object)TOKEN05, (Object)TOKEN06, (Object)TOKEN07, (Object)TOKEN08, (Object)TOKEN09, (Object)TOKEN10, (Object)TOKEN11, (Object)TOKEN12, (Object[])new Token[]{TOKEN13, TOKEN14, TOKEN15, TOKEN16, TOKEN17, TOKEN18});
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        this.locate(this.node3, DC1, RACK11);
        this.locate(this.node4, DC2, RACK21);
        this.locate(this.node5, DC1, RACK12);
        this.locate(this.node6, DC2, RACK22);
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)this.node1).put((Object)TOKEN02, (Object)this.node1).put((Object)TOKEN03, (Object)this.node5).put((Object)TOKEN04, (Object)this.node3).put((Object)TOKEN05, (Object)this.node1).put((Object)TOKEN06, (Object)this.node5).put((Object)TOKEN07, (Object)this.node2).put((Object)TOKEN08, (Object)this.node6).put((Object)TOKEN09, (Object)this.node3).put((Object)TOKEN10, (Object)this.node4).put((Object)TOKEN11, (Object)this.node5).put((Object)TOKEN12, (Object)this.node4).put((Object)TOKEN13, (Object)this.node4).put((Object)TOKEN14, (Object)this.node2).put((Object)TOKEN15, (Object)this.node6).put((Object)TOKEN16, (Object)this.node3).put((Object)TOKEN17, (Object)this.node2).put((Object)TOKEN18, (Object)this.node6).build();
        NetworkTopologyReplicationStrategy strategy = new NetworkTopologyReplicationStrategy((Map)ImmutableMap.of((Object)DC1, (Object)Integer.toString(replicationFactor), (Object)DC2, (Object)Integer.toString(replicationFactor)), "test");
        return strategy.computeReplicasByToken((Map)tokenToPrimary, (List)ring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_abort_early_and_log_when_bad_replication_factor_cannot_be_met() {
        ImmutableList ring = ImmutableList.of((Object)TOKEN01, (Object)TOKEN04, (Object)TOKEN14, (Object)TOKEN19);
        this.locate(this.node1, DC1, RACK11);
        this.locate(this.node2, DC2, RACK21);
        ImmutableMap tokenToPrimary = ImmutableMap.of((Object)TOKEN01, (Object)this.node1, (Object)TOKEN04, (Object)this.node2, (Object)TOKEN14, (Object)this.node1, (Object)TOKEN19, (Object)this.node2);
        Logger logger = (Logger)LoggerFactory.getLogger(NetworkTopologyReplicationStrategy.class);
        logger.addAppender(this.appender);
        try {
            int traversedTokensForValidSettings = this.countTraversedTokens((List<Token>)ring, (Map<Token, Node>)tokenToPrimary, (ImmutableMap<String, String>)ImmutableMap.of((Object)DC1, (Object)"1", (Object)DC2, (Object)"1"));
            ((Appender)Mockito.verify(this.appender, (VerificationMode)Mockito.never())).doAppend((Object)((ILoggingEvent)ArgumentMatchers.any(ILoggingEvent.class)));
            int traversedTokensForInvalidSettings = this.countTraversedTokens((List<Token>)ring, (Map<Token, Node>)tokenToPrimary, (ImmutableMap<String, String>)ImmutableMap.of((Object)DC1, (Object)"1", (Object)DC2, (Object)"1", (Object)DC3, (Object)"1"));
            Assertions.assertThat((int)traversedTokensForInvalidSettings).isEqualTo(traversedTokensForValidSettings);
            ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
            ILoggingEvent log = (ILoggingEvent)this.loggingEventCaptor.getValue();
            Assertions.assertThat((Object)log.getLevel()).isEqualTo((Object)Level.WARN);
            Assertions.assertThat((String)log.getMessage()).contains(new CharSequence[]{"could not achieve replication factor"});
        }
        finally {
            logger.detachAppender(this.appender);
        }
    }

    private int countTraversedTokens(List<Token> ring, Map<Token, Node> tokenToPrimary, ImmutableMap<String, String> replicationConfig) {
        AtomicInteger count = new AtomicInteger();
        List ringSpy = (List)Mockito.spy(ring);
        Mockito.when((Object)((Token)ringSpy.get(ArgumentMatchers.anyInt()))).thenAnswer(invocation -> {
            count.incrementAndGet();
            return invocation.callRealMethod();
        });
        new NetworkTopologyReplicationStrategy(replicationConfig, "test").computeReplicasByToken(tokenToPrimary, ringSpy);
        return count.get();
    }

    private void locate(Node node, String dc, String rack) {
        Mockito.when((Object)node.getDatacenter()).thenReturn((Object)dc);
        Mockito.when((Object)node.getRack()).thenReturn((Object)rack);
    }
}

