/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedToken;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedTokenRange;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ByteOrderedTokenRangeTest {
    private static final String MIN = "0x";

    @Test
    public void should_split_range() {
        Assertions.assertThat((List)this.range("0x0a", "0x0d").splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range("0x0a", "0x0b"), this.range("0x0b", "0x0c"), this.range("0x0c", "0x0d")});
    }

    @Test
    public void should_split_range_producing_empty_splits_near_ring_end() {
        Assertions.assertThat((List)this.range(MIN, "0x00").splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(MIN, "0x00"), this.range("0x00", "0x00"), this.range("0x00", "0x00")});
    }

    @Test
    public void should_split_range_when_padding_produces_same_token() {
        Assertions.assertThat((List)this.range("0x11", "0x1100").splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range("0x11", "0x1100"), this.range("0x1100", "0x1100"), this.range("0x1100", "0x1100")});
    }

    @Test
    public void should_split_range_that_wraps_around_the_ring() {
        Assertions.assertThat((List)this.range("0x0d", "0x0a").splitEvenly(2)).containsExactly((Object[])new TokenRange[]{this.range("0x0d", "0x8c"), this.range("0x8c", "0x0a")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_split_whole_ring() {
        this.range(MIN, MIN).splitEvenly(1);
    }

    private ByteOrderedTokenRange range(String start, String end) {
        return new ByteOrderedTokenRange(new ByteOrderedToken(Bytes.fromHexString((String)start)), new ByteOrderedToken(Bytes.fromHexString((String)end)));
    }
}

