/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserTestBase;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.ViewParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.CassandraSchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class ViewParserTest
extends SchemaParserTestBase {
    static final AdminRow VIEW_ROW_3_0 = ViewParserTest.mockViewRow("ks", "alltimehigh", "scores", false, "game IS NOT NULL");
    static final ImmutableList<AdminRow> COLUMN_ROWS_3_0 = ImmutableList.of((Object)ViewParserTest.mockModernColumnRow("ks", "alltimehigh", "game", "partition_key", "text", "none", 0), (Object)ViewParserTest.mockModernColumnRow("ks", "alltimehigh", "score", "clustering", "int", "desc", 0), (Object)ViewParserTest.mockModernColumnRow("ks", "alltimehigh", "user", "clustering", "text", "asc", 1), (Object)ViewParserTest.mockModernColumnRow("ks", "alltimehigh", "year", "clustering", "int", "asc", 2), (Object)ViewParserTest.mockModernColumnRow("ks", "alltimehigh", "month", "clustering", "int", "asc", 3), (Object)ViewParserTest.mockModernColumnRow("ks", "alltimehigh", "day", "clustering", "int", "asc", 4));

    @Test
    public void should_skip_when_no_column_rows() {
        SchemaRows rows = this.rows(VIEW_ROW_3_0, Collections.emptyList());
        ViewParser parser = new ViewParser(rows, this.context);
        ViewMetadata view = parser.parseView(VIEW_ROW_3_0, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((Object)view).isNull();
    }

    @Test
    public void should_parse_view() {
        SchemaRows rows = this.rows(VIEW_ROW_3_0, (Iterable<AdminRow>)COLUMN_ROWS_3_0);
        ViewParser parser = new ViewParser(rows, this.context);
        ViewMetadata view = parser.parseView(VIEW_ROW_3_0, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((String)view.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)view.getName().asInternal()).isEqualTo("alltimehigh");
        Assertions.assertThat((String)view.getBaseTable().asInternal()).isEqualTo("scores");
        Assertions.assertThat((List)view.getPartitionKey()).hasSize(1);
        ColumnMetadata pk0 = (ColumnMetadata)view.getPartitionKey().get(0);
        Assertions.assertThat((String)pk0.getName().asInternal()).isEqualTo("game");
        Assertions.assertThat((Object)pk0.getType()).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat(view.getClusteringColumns().entrySet()).hasSize(5);
        Iterator clusteringColumnsIterator = view.getClusteringColumns().keySet().iterator();
        Assertions.assertThat((String)((ColumnMetadata)clusteringColumnsIterator.next()).getName().asInternal()).isEqualTo("score");
        Assertions.assertThat((String)((ColumnMetadata)clusteringColumnsIterator.next()).getName().asInternal()).isEqualTo("user");
        Assertions.assertThat((String)((ColumnMetadata)clusteringColumnsIterator.next()).getName().asInternal()).isEqualTo("year");
        Assertions.assertThat((String)((ColumnMetadata)clusteringColumnsIterator.next()).getName().asInternal()).isEqualTo("month");
        Assertions.assertThat((String)((ColumnMetadata)clusteringColumnsIterator.next()).getName().asInternal()).isEqualTo("day");
        Assertions.assertThat((Map)view.getColumns()).containsOnlyKeys((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"game"), CqlIdentifier.fromInternal((String)"score"), CqlIdentifier.fromInternal((String)"user"), CqlIdentifier.fromInternal((String)"year"), CqlIdentifier.fromInternal((String)"month"), CqlIdentifier.fromInternal((String)"day")});
    }

    private SchemaRows rows(AdminRow viewRow, Iterable<AdminRow> columnRows) {
        return new CassandraSchemaRows.Builder(true, null, "test").withViews((Iterable)ImmutableList.of((Object)viewRow)).withColumns(columnRows).build();
    }
}

