/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexKind;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserTestBase;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.TableParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.CassandraSchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class TableParserTest
extends SchemaParserTestBase {
    private static final AdminRow TABLE_ROW_2_2 = TableParserTest.mockLegacyTableRow("ks", "foo", "org.apache.cassandra.db.marshal.CompositeType(org.apache.cassandra.db.marshal.Int32Type,org.apache.cassandra.db.marshal.Int32Type,org.apache.cassandra.db.marshal.UTF8Type)");
    private static final ImmutableList<AdminRow> COLUMN_ROWS_2_2 = ImmutableList.of((Object)TableParserTest.mockLegacyColumnRow("ks", "foo", "k2", "partition_key", "org.apache.cassandra.db.marshal.UTF8Type", 1), (Object)TableParserTest.mockLegacyColumnRow("ks", "foo", "k1", "partition_key", "org.apache.cassandra.db.marshal.Int32Type", 0), (Object)TableParserTest.mockLegacyColumnRow("ks", "foo", "cc1", "clustering_key", "org.apache.cassandra.db.marshal.Int32Type", 0), (Object)TableParserTest.mockLegacyColumnRow("ks", "foo", "cc2", "clustering_key", "org.apache.cassandra.db.marshal.ReversedType(org.apache.cassandra.db.marshal.Int32Type)", 1), (Object)TableParserTest.mockLegacyColumnRow("ks", "foo", "v", "regular", "org.apache.cassandra.db.marshal.ReversedType(org.apache.cassandra.db.marshal.Int32Type)", -1, "foo_v_idx", "COMPOSITES", "{}"));
    static final AdminRow TABLE_ROW_3_0 = TableParserTest.mockModernTableRow("ks", "foo");
    static final ImmutableList<AdminRow> COLUMN_ROWS_3_0 = ImmutableList.of((Object)TableParserTest.mockModernColumnRow("ks", "foo", "k2", "partition_key", "text", "none", 1), (Object)TableParserTest.mockModernColumnRow("ks", "foo", "k1", "partition_key", "int", "none", 0), (Object)TableParserTest.mockModernColumnRow("ks", "foo", "cc1", "clustering", "int", "asc", 0), (Object)TableParserTest.mockModernColumnRow("ks", "foo", "cc2", "clustering", "int", "desc", 1), (Object)TableParserTest.mockModernColumnRow("ks", "foo", "v", "regular", "int", "none", -1));
    static final ImmutableList<AdminRow> INDEX_ROWS_3_0 = ImmutableList.of((Object)TableParserTest.mockIndexRow("ks", "foo", "foo_v_idx", "COMPOSITES", (ImmutableMap<String, String>)ImmutableMap.of((Object)"target", (Object)"v")));

    @Test
    public void should_skip_when_no_column_rows() {
        SchemaRows rows = this.legacyRows(TABLE_ROW_2_2, Collections.emptyList());
        TableParser parser = new TableParser(rows, this.context);
        TableMetadata table = parser.parseTable(TABLE_ROW_2_2, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((Object)table).isNull();
    }

    @Test
    public void should_parse_legacy_tables() {
        SchemaRows rows = this.legacyRows(TABLE_ROW_2_2, (Iterable<AdminRow>)COLUMN_ROWS_2_2);
        TableParser parser = new TableParser(rows, this.context);
        TableMetadata table = parser.parseTable(TABLE_ROW_2_2, KEYSPACE_ID, Collections.emptyMap());
        this.checkTable(table);
        Assertions.assertThat(table.getOptions().get(CqlIdentifier.fromInternal((String)"caching"))).isEqualTo((Object)"{\"keys\":\"ALL\", \"rows_per_partition\":\"NONE\"}");
    }

    @Test
    public void should_parse_modern_tables() {
        SchemaRows rows = this.modernRows(TABLE_ROW_3_0, (Iterable<AdminRow>)COLUMN_ROWS_3_0, (Iterable<AdminRow>)INDEX_ROWS_3_0);
        TableParser parser = new TableParser(rows, this.context);
        TableMetadata table = parser.parseTable(TABLE_ROW_3_0, KEYSPACE_ID, Collections.emptyMap());
        this.checkTable(table);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)table.getOptions().get(CqlIdentifier.fromInternal((String)"caching")))).hasSize(2)).containsEntry((Object)"keys", (Object)"ALL")).containsEntry((Object)"rows_per_partition", (Object)"NONE");
    }

    private void checkTable(TableMetadata table) {
        Assertions.assertThat((String)table.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)table.getName().asInternal()).isEqualTo("foo");
        Assertions.assertThat((List)table.getPartitionKey()).hasSize(2);
        ColumnMetadata pk0 = (ColumnMetadata)table.getPartitionKey().get(0);
        Assertions.assertThat((String)pk0.getName().asInternal()).isEqualTo("k1");
        Assertions.assertThat((Object)pk0.getType()).isEqualTo((Object)DataTypes.INT);
        ColumnMetadata pk1 = (ColumnMetadata)table.getPartitionKey().get(1);
        Assertions.assertThat((String)pk1.getName().asInternal()).isEqualTo("k2");
        Assertions.assertThat((Object)pk1.getType()).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat(table.getClusteringColumns().entrySet()).hasSize(2);
        Iterator clusteringColumnsIterator = table.getClusteringColumns().keySet().iterator();
        ColumnMetadata clusteringColumn1 = (ColumnMetadata)clusteringColumnsIterator.next();
        Assertions.assertThat((String)clusteringColumn1.getName().asInternal()).isEqualTo("cc1");
        ColumnMetadata clusteringColumn2 = (ColumnMetadata)clusteringColumnsIterator.next();
        Assertions.assertThat((String)clusteringColumn2.getName().asInternal()).isEqualTo("cc2");
        Assertions.assertThat(table.getClusteringColumns().values()).containsExactly((Object[])new ClusteringOrder[]{ClusteringOrder.ASC, ClusteringOrder.DESC});
        Assertions.assertThat((Map)table.getColumns()).containsOnlyKeys((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"k1"), CqlIdentifier.fromInternal((String)"k2"), CqlIdentifier.fromInternal((String)"cc1"), CqlIdentifier.fromInternal((String)"cc2"), CqlIdentifier.fromInternal((String)"v")});
        ColumnMetadata regularColumn = (ColumnMetadata)table.getColumns().get(CqlIdentifier.fromInternal((String)"v"));
        Assertions.assertThat((String)regularColumn.getName().asInternal()).isEqualTo("v");
        Assertions.assertThat((Object)regularColumn.getType()).isEqualTo((Object)DataTypes.INT);
        Assertions.assertThat((Map)table.getIndexes()).containsOnlyKeys((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"foo_v_idx")});
        IndexMetadata index = (IndexMetadata)table.getIndexes().get(CqlIdentifier.fromInternal((String)"foo_v_idx"));
        Assertions.assertThat((String)index.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)index.getTable().asInternal()).isEqualTo("foo");
        Assertions.assertThat((String)index.getName().asInternal()).isEqualTo("foo_v_idx");
        Assertions.assertThat((Optional)index.getClassName()).isNotPresent();
        Assertions.assertThat((Comparable)index.getKind()).isEqualTo((Object)IndexKind.COMPOSITES);
        Assertions.assertThat((String)index.getTarget()).isEqualTo("v");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)table.getOptions().get(CqlIdentifier.fromInternal((String)"compaction")))).hasSize(2)).containsEntry((Object)"class", (Object)"org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy")).containsEntry((Object)"mock_option", (Object)"1");
    }

    private SchemaRows legacyRows(AdminRow tableRow, Iterable<AdminRow> columnRows) {
        return this.rows(tableRow, columnRows, null, false);
    }

    private SchemaRows modernRows(AdminRow tableRow, Iterable<AdminRow> columnRows, Iterable<AdminRow> indexesRows) {
        return this.rows(tableRow, columnRows, indexesRows, true);
    }

    private SchemaRows rows(AdminRow tableRow, Iterable<AdminRow> columnRows, Iterable<AdminRow> indexesRows, boolean isCassandraV3) {
        CassandraSchemaRows.Builder builder = new CassandraSchemaRows.Builder(isCassandraV3, null, "test").withTables((Iterable)ImmutableList.of((Object)tableRow)).withColumns(columnRows);
        if (indexesRows != null) {
            builder.withIndexes(indexesRows);
        }
        return builder.build();
    }
}

