/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataTypeClassNameParserTest {
    private static final CqlIdentifier KEYSPACE_ID = CqlIdentifier.fromInternal((String)"ks");
    @Mock
    private InternalDriverContext context;
    private DataTypeClassNameParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new DataTypeClassNameParser();
    }

    @Test
    public void should_parse_native_types() {
        for (Map.Entry entry : DataTypeClassNameParser.NATIVE_TYPES_BY_CLASS_NAME.entrySet()) {
            String className = (String)entry.getKey();
            DataType expectedType = (DataType)entry.getValue();
            Assertions.assertThat((Object)this.parse(className)).isEqualTo((Object)expectedType);
        }
    }

    @Test
    public void should_parse_collection_types() {
        Assertions.assertThat((Object)this.parse("org.apache.cassandra.db.marshal.ListType(org.apache.cassandra.db.marshal.UTF8Type)")).isEqualTo((Object)DataTypes.listOf((DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("org.apache.cassandra.db.marshal.FrozenType(org.apache.cassandra.db.marshal.ListType(org.apache.cassandra.db.marshal.UTF8Type))")).isEqualTo((Object)DataTypes.frozenListOf((DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("org.apache.cassandra.db.marshal.SetType(org.apache.cassandra.db.marshal.UTF8Type)")).isEqualTo((Object)DataTypes.setOf((DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("org.apache.cassandra.db.marshal.MapType(org.apache.cassandra.db.marshal.UTF8Type,org.apache.cassandra.db.marshal.UTF8Type)")).isEqualTo((Object)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("org.apache.cassandra.db.marshal.MapType(org.apache.cassandra.db.marshal.UTF8Type,org.apache.cassandra.db.marshal.FrozenType(org.apache.cassandra.db.marshal.MapType(org.apache.cassandra.db.marshal.Int32Type,org.apache.cassandra.db.marshal.Int32Type)))")).isEqualTo((Object)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.frozenMapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT)));
    }

    @Test
    public void should_parse_user_type_when_definition_not_already_available() {
        UserDefinedType addressType = (UserDefinedType)this.parse("org.apache.cassandra.db.marshal.UserType(foo,61646472657373,737472656574:org.apache.cassandra.db.marshal.UTF8Type,7a6970636f6465:org.apache.cassandra.db.marshal.Int32Type,70686f6e6573:org.apache.cassandra.db.marshal.SetType(org.apache.cassandra.db.marshal.UserType(foo,70686f6e65,6e616d65:org.apache.cassandra.db.marshal.UTF8Type,6e756d626572:org.apache.cassandra.db.marshal.UTF8Type)))");
        Assertions.assertThat((String)addressType.getKeyspace().asInternal()).isEqualTo("foo");
        Assertions.assertThat((String)addressType.getName().asInternal()).isEqualTo("address");
        Assertions.assertThat((boolean)addressType.isFrozen()).isTrue();
        Assertions.assertThat((int)addressType.getFieldNames().size()).isEqualTo(3);
        Assertions.assertThat((String)((CqlIdentifier)addressType.getFieldNames().get(0)).asInternal()).isEqualTo("street");
        Assertions.assertThat((Object)((DataType)addressType.getFieldTypes().get(0))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((String)((CqlIdentifier)addressType.getFieldNames().get(1)).asInternal()).isEqualTo("zipcode");
        Assertions.assertThat((Object)((DataType)addressType.getFieldTypes().get(1))).isEqualTo((Object)DataTypes.INT);
        Assertions.assertThat((String)((CqlIdentifier)addressType.getFieldNames().get(2)).asInternal()).isEqualTo("phones");
        DataType phonesType = (DataType)addressType.getFieldTypes().get(2);
        Assertions.assertThat((Object)phonesType).isInstanceOf(SetType.class);
        UserDefinedType phoneType = (UserDefinedType)((SetType)phonesType).getElementType();
        Assertions.assertThat((String)phoneType.getKeyspace().asInternal()).isEqualTo("foo");
        Assertions.assertThat((String)phoneType.getName().asInternal()).isEqualTo("phone");
        Assertions.assertThat((boolean)phoneType.isFrozen()).isTrue();
        Assertions.assertThat((int)phoneType.getFieldNames().size()).isEqualTo(2);
        Assertions.assertThat((String)((CqlIdentifier)phoneType.getFieldNames().get(0)).asInternal()).isEqualTo("name");
        Assertions.assertThat((Object)((DataType)phoneType.getFieldTypes().get(0))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((String)((CqlIdentifier)phoneType.getFieldNames().get(1)).asInternal()).isEqualTo("number");
        Assertions.assertThat((Object)((DataType)phoneType.getFieldTypes().get(1))).isEqualTo((Object)DataTypes.TEXT);
    }

    @Test
    public void should_make_a_frozen_copy_user_type_when_definition_already_available() {
        UserDefinedType existing = (UserDefinedType)Mockito.mock(UserDefinedType.class);
        this.parse("org.apache.cassandra.db.marshal.UserType(foo,70686f6e65,6e616d65:org.apache.cassandra.db.marshal.UTF8Type,6e756d626572:org.apache.cassandra.db.marshal.UTF8Type)", (Map<CqlIdentifier, UserDefinedType>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"phone"), (Object)existing));
        ((UserDefinedType)Mockito.verify((Object)existing)).copy(true);
    }

    @Test
    public void should_parse_tuple() {
        TupleType tupleType = (TupleType)this.parse("org.apache.cassandra.db.marshal.TupleType(org.apache.cassandra.db.marshal.Int32Type,org.apache.cassandra.db.marshal.UTF8Type,org.apache.cassandra.db.marshal.FloatType)");
        Assertions.assertThat((int)tupleType.getComponentTypes().size()).isEqualTo(3);
        Assertions.assertThat((Object)((DataType)tupleType.getComponentTypes().get(0))).isEqualTo((Object)DataTypes.INT);
        Assertions.assertThat((Object)((DataType)tupleType.getComponentTypes().get(1))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((Object)((DataType)tupleType.getComponentTypes().get(2))).isEqualTo((Object)DataTypes.FLOAT);
    }

    private DataType parse(String toParse) {
        return this.parse(toParse, null);
    }

    private DataType parse(String toParse, Map<CqlIdentifier, UserDefinedType> existingTypes) {
        return this.parser.parse(KEYSPACE_ID, toParse, existingTypes, this.context);
    }
}

