/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.AggregateParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeCqlNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserTestBase;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AggregateParserTest
extends SchemaParserTestBase {
    private static final AdminRow SUM_AND_TO_STRING_ROW_2_2 = AggregateParserTest.mockAggregateRow("ks", "sum_and_to_string", (List<String>)ImmutableList.of((Object)"org.apache.cassandra.db.marshal.Int32Type"), "plus", "org.apache.cassandra.db.marshal.Int32Type", "to_string", "org.apache.cassandra.db.marshal.UTF8Type", Bytes.fromHexString((String)"0x00000000"));
    static final AdminRow SUM_AND_TO_STRING_ROW_3_0 = AggregateParserTest.mockAggregateRow("ks", "sum_and_to_string", (List<String>)ImmutableList.of((Object)"int"), "plus", "int", "to_string", "text", "0");

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)new DefaultCodecRegistry("test", new TypeCodec[0]));
        Mockito.when((Object)this.context.getProtocolVersion()).thenReturn((Object)ProtocolVersion.DEFAULT);
    }

    @Test
    public void should_parse_modern_table() {
        AggregateParser parser = new AggregateParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        AggregateMetadata aggregate = parser.parseAggregate(SUM_AND_TO_STRING_ROW_3_0, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((String)aggregate.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)aggregate.getSignature().getName().asInternal()).isEqualTo("sum_and_to_string");
        Assertions.assertThat((List)aggregate.getSignature().getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
        FunctionSignature stateFuncSignature = aggregate.getStateFuncSignature();
        Assertions.assertThat((String)stateFuncSignature.getName().asInternal()).isEqualTo("plus");
        Assertions.assertThat((List)stateFuncSignature.getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT, DataTypes.INT});
        Assertions.assertThat((Object)aggregate.getStateType()).isEqualTo((Object)DataTypes.INT);
        Optional finalFuncSignature = aggregate.getFinalFuncSignature();
        Assertions.assertThat((Optional)finalFuncSignature).isPresent();
        Assertions.assertThat((Optional)finalFuncSignature).hasValueSatisfying(signature -> {
            Assertions.assertThat((String)signature.getName().asInternal()).isEqualTo("to_string");
            Assertions.assertThat((List)signature.getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
        });
        Assertions.assertThat((Object)aggregate.getReturnType()).isEqualTo((Object)DataTypes.TEXT);
        ((ObjectAssert)Assertions.assertThat(aggregate.getInitCond().get()).isInstanceOf(Integer.class)).isEqualTo((Object)0);
    }

    @Test
    public void should_parse_legacy_table() {
        AggregateParser parser = new AggregateParser((DataTypeParser)new DataTypeClassNameParser(), this.context);
        AggregateMetadata aggregate = parser.parseAggregate(SUM_AND_TO_STRING_ROW_2_2, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((String)aggregate.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)aggregate.getSignature().getName().asInternal()).isEqualTo("sum_and_to_string");
        Assertions.assertThat((List)aggregate.getSignature().getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
        FunctionSignature stateFuncSignature = aggregate.getStateFuncSignature();
        Assertions.assertThat((String)stateFuncSignature.getName().asInternal()).isEqualTo("plus");
        Assertions.assertThat((List)stateFuncSignature.getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT, DataTypes.INT});
        Assertions.assertThat((Object)aggregate.getStateType()).isEqualTo((Object)DataTypes.INT);
        Optional finalFuncSignature = aggregate.getFinalFuncSignature();
        Assertions.assertThat((Optional)finalFuncSignature).isPresent();
        Assertions.assertThat((Optional)finalFuncSignature).hasValueSatisfying(signature -> {
            Assertions.assertThat((String)signature.getName().asInternal()).isEqualTo("to_string");
            Assertions.assertThat((List)signature.getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
        });
        Assertions.assertThat((Object)aggregate.getReturnType()).isEqualTo((Object)DataTypes.TEXT);
        ((ObjectAssert)Assertions.assertThat(aggregate.getInitCond().get()).isInstanceOf(Integer.class)).isEqualTo((Object)0);
    }
}

