/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DistanceEvent;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LoadBalancingPolicyWrapperTest {
    private DefaultNode node1;
    private DefaultNode node2;
    private DefaultNode node3;
    private Map<UUID, Node> allNodes;
    private Set<DefaultNode> contactPoints;
    private Queue<Node> defaultPolicysQueryPlan;
    @Mock
    private InternalDriverContext context;
    @Mock
    private LoadBalancingPolicy policy1;
    @Mock
    private LoadBalancingPolicy policy2;
    @Mock
    private LoadBalancingPolicy policy3;
    private EventBus eventBus;
    @Mock
    private MetadataManager metadataManager;
    @Mock
    private Metadata metadata;
    @Mock
    protected MetricsFactory metricsFactory;
    @Captor
    private ArgumentCaptor<Map<UUID, Node>> initNodesCaptor;
    private LoadBalancingPolicyWrapper wrapper;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, this.context);
        this.node3 = TestNodeFactory.newNode(3, this.context);
        this.contactPoints = ImmutableSet.of((Object)this.node1, (Object)this.node2);
        this.allNodes = ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1, (Object)this.node2.getHostId(), (Object)this.node2, (Object)this.node3.getHostId(), (Object)this.node3);
        Mockito.when((Object)this.metadataManager.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getNodes()).thenReturn(this.allNodes);
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn(this.contactPoints);
        Mockito.when((Object)this.context.getMetadataManager()).thenReturn((Object)this.metadataManager);
        this.defaultPolicysQueryPlan = Lists.newLinkedList((Iterable)ImmutableList.of((Object)this.node3, (Object)this.node2, (Object)this.node1));
        Mockito.when((Object)this.policy1.newQueryPlan(null, null)).thenReturn(this.defaultPolicysQueryPlan);
        this.eventBus = (EventBus)Mockito.spy((Object)new EventBus("test"));
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        this.wrapper = new LoadBalancingPolicyWrapper(this.context, (Map)ImmutableMap.of((Object)"default", (Object)this.policy1, (Object)"profile1", (Object)this.policy1, (Object)"profile2", (Object)this.policy2, (Object)"profile3", (Object)this.policy3));
    }

    @Test
    public void should_build_query_plan_from_contact_points_before_init() {
        Queue queryPlan = this.wrapper.newQueryPlan();
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.never())).newQueryPlan(null, null);
        }
        Assertions.assertThat((Iterable)queryPlan).containsOnlyElementsOf(this.contactPoints);
    }

    @Test
    public void should_fetch_query_plan_from_policy_after_init() {
        this.wrapper.init();
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.verify((Object)policy)).init(ArgumentMatchers.anyMap(), (LoadBalancingPolicy.DistanceReporter)ArgumentMatchers.any(LoadBalancingPolicy.DistanceReporter.class));
        }
        Queue queryPlan = this.wrapper.newQueryPlan();
        ((LoadBalancingPolicy)Mockito.verify((Object)this.policy1)).newQueryPlan(null, null);
        Assertions.assertThat((Iterable)queryPlan).isEqualTo(this.defaultPolicysQueryPlan);
    }

    @Test
    public void should_init_policies_with_all_nodes() {
        this.node1.state = NodeState.UP;
        this.node2.state = NodeState.UNKNOWN;
        this.node3.state = NodeState.DOWN;
        this.wrapper.init();
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.verify((Object)policy)).init((Map)this.initNodesCaptor.capture(), (LoadBalancingPolicy.DistanceReporter)ArgumentMatchers.any(LoadBalancingPolicy.DistanceReporter.class));
            Map initNodes = (Map)this.initNodesCaptor.getValue();
            Assertions.assertThat(initNodes.values()).containsOnly((Object[])new Node[]{this.node1, this.node2, this.node3});
        }
    }

    @Test
    public void should_propagate_distances_from_policies() {
        this.wrapper.init();
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(LoadBalancingPolicy.DistanceReporter.class);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.policy1)).init(ArgumentMatchers.anyMap(), (LoadBalancingPolicy.DistanceReporter)captor1.capture());
        LoadBalancingPolicy.DistanceReporter distanceReporter1 = (LoadBalancingPolicy.DistanceReporter)captor1.getValue();
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(LoadBalancingPolicy.DistanceReporter.class);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.policy2)).init(ArgumentMatchers.anyMap(), (LoadBalancingPolicy.DistanceReporter)captor2.capture());
        LoadBalancingPolicy.DistanceReporter distanceReporter2 = (LoadBalancingPolicy.DistanceReporter)captor1.getValue();
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(LoadBalancingPolicy.DistanceReporter.class);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.policy3)).init(ArgumentMatchers.anyMap(), (LoadBalancingPolicy.DistanceReporter)captor3.capture());
        LoadBalancingPolicy.DistanceReporter distanceReporter3 = (LoadBalancingPolicy.DistanceReporter)captor3.getValue();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        distanceReporter1.setDistance((Node)this.node1, NodeDistance.REMOTE);
        ((EventBus)inOrder.verify((Object)this.eventBus)).fire((Object)new DistanceEvent(NodeDistance.REMOTE, this.node1));
        distanceReporter2.setDistance((Node)this.node1, NodeDistance.REMOTE);
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.times((int)0))).fire(ArgumentMatchers.any(DistanceEvent.class));
        distanceReporter2.setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((EventBus)inOrder.verify((Object)this.eventBus)).fire((Object)new DistanceEvent(NodeDistance.LOCAL, this.node1));
        distanceReporter3.setDistance((Node)this.node1, NodeDistance.IGNORED);
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.times((int)0))).fire(ArgumentMatchers.any(DistanceEvent.class));
    }

    @Test
    public void should_not_propagate_node_states_to_policies_until_init() {
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.UNKNOWN, (NodeState)NodeState.UP, (DefaultNode)this.node1));
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.never())).onUp((Node)this.node1);
        }
    }

    @Test
    public void should_propagate_node_states_to_policies_after_init() {
        this.wrapper.init();
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.UNKNOWN, (NodeState)NodeState.UP, (DefaultNode)this.node1));
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.verify((Object)policy)).onUp((Node)this.node1);
        }
    }

    @Test
    public void should_accumulate_events_during_init_and_replay() throws InterruptedException {
        CountDownLatch eventLatch = new CountDownLatch(3);
        CountDownLatch initLatch = new CountDownLatch(1);
        Answer mockInit = i -> {
            eventLatch.countDown();
            initLatch.await(500L, TimeUnit.MILLISECONDS);
            return null;
        };
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.doAnswer((Answer)mockInit).when((Object)policy)).init(ArgumentMatchers.anyMap(), (LoadBalancingPolicy.DistanceReporter)ArgumentMatchers.any(LoadBalancingPolicy.DistanceReporter.class));
        }
        Runnable runnable = () -> {
            try {
                eventLatch.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.UNKNOWN, (NodeState)NodeState.DOWN, (DefaultNode)this.node1));
            initLatch.countDown();
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.wrapper.init();
        initLatch.await(500L, TimeUnit.MILLISECONDS);
        for (LoadBalancingPolicy policy : ImmutableList.of((Object)this.policy1, (Object)this.policy2, (Object)this.policy3)) {
            ((LoadBalancingPolicy)Mockito.verify((Object)policy)).onDown((Node)this.node1);
        }
        if (thread.isAlive()) {
            Thread.sleep(500L);
        }
        Assertions.assertThat((boolean)thread.isAlive()).isFalse();
    }
}

