/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DefaultNodeInfo;
import com.datastax.oss.driver.internal.core.metadata.FullNodeListRefresh;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FullNodeListRefreshTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    protected MetricsFactory metricsFactory;
    private DefaultNode node1;
    private DefaultNode node2;
    private EndPoint endPoint3;
    private UUID hostId3;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, this.context);
        this.endPoint3 = TestNodeFactory.newEndPoint(3);
        this.hostId3 = UUID.randomUUID();
    }

    @Test
    public void should_add_and_remove_nodes() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1, (Object)this.node2.getHostId(), (Object)this.node2), Collections.emptyMap(), null);
        ImmutableList newInfos = ImmutableList.of((Object)DefaultNodeInfo.builder().withEndPoint(this.node2.getEndPoint()).withHostId(this.node2.getHostId()).build(), (Object)DefaultNodeInfo.builder().withEndPoint(this.endPoint3).withHostId(this.hostId3).build());
        FullNodeListRefresh refresh = new FullNodeListRefresh((Iterable)newInfos);
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getNodes()).containsOnlyKeys((Object[])new UUID[]{this.node2.getHostId(), this.hostId3});
        DefaultNode node3 = (DefaultNode)result.newMetadata.getNodes().get(this.hostId3);
        Assertions.assertThat((List)result.events).containsOnly(new Object[]{NodeStateEvent.removed((DefaultNode)this.node1), NodeStateEvent.added((DefaultNode)node3)});
    }

    @Test
    public void should_update_existing_nodes() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1, (Object)this.node2.getHostId(), (Object)this.node2), Collections.emptyMap(), null);
        UUID schemaVersion1 = Uuids.random();
        UUID schemaVersion2 = Uuids.random();
        ImmutableList newInfos = ImmutableList.of((Object)DefaultNodeInfo.builder().withEndPoint(this.node1.getEndPoint()).withDatacenter("dc1").withRack("rack1").withHostId(this.node1.getHostId()).withSchemaVersion(schemaVersion1).build(), (Object)DefaultNodeInfo.builder().withEndPoint(this.node2.getEndPoint()).withDatacenter("dc1").withRack("rack2").withHostId(this.node2.getHostId()).withSchemaVersion(schemaVersion2).build());
        FullNodeListRefresh refresh = new FullNodeListRefresh((Iterable)newInfos);
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getNodes()).containsOnlyKeys((Object[])new UUID[]{this.node1.getHostId(), this.node2.getHostId()});
        Assertions.assertThat((String)this.node1.getDatacenter()).isEqualTo("dc1");
        Assertions.assertThat((String)this.node1.getRack()).isEqualTo("rack1");
        Assertions.assertThat((Comparable)this.node1.getSchemaVersion()).isEqualTo((Object)schemaVersion1);
        Assertions.assertThat((String)this.node2.getDatacenter()).isEqualTo("dc1");
        Assertions.assertThat((String)this.node2.getRack()).isEqualTo("rack2");
        Assertions.assertThat((Comparable)this.node2.getSchemaVersion()).isEqualTo((Object)schemaVersion2);
        Assertions.assertThat((List)result.events).isEmpty();
    }
}

