/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.AddNodeRefresh;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DefaultNodeInfo;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metadata.TopologyEvent;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AddNodeRefreshTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    protected MetricsFactory metricsFactory;
    private DefaultNode node1;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
    }

    @Test
    public void should_add_new_node() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1), Collections.emptyMap(), null);
        UUID newHostId = Uuids.random();
        DefaultEndPoint newEndPoint = TestNodeFactory.newEndPoint(2);
        UUID newSchemaVersion = Uuids.random();
        DefaultNodeInfo newNodeInfo = DefaultNodeInfo.builder().withHostId(newHostId).withEndPoint((EndPoint)newEndPoint).withDatacenter("dc1").withRack("rack2").withSchemaVersion(newSchemaVersion).build();
        AddNodeRefresh refresh = new AddNodeRefresh((NodeInfo)newNodeInfo);
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Map newNodes = result.newMetadata.getNodes();
        Assertions.assertThat((Map)newNodes).containsOnlyKeys((Object[])new UUID[]{this.node1.getHostId(), newHostId});
        Node node2 = (Node)newNodes.get(newHostId);
        Assertions.assertThat((Object)node2.getEndPoint()).isEqualTo((Object)newEndPoint);
        Assertions.assertThat((String)node2.getDatacenter()).isEqualTo("dc1");
        Assertions.assertThat((String)node2.getRack()).isEqualTo("rack2");
        Assertions.assertThat((Comparable)node2.getHostId()).isEqualTo((Object)newHostId);
        Assertions.assertThat((Comparable)node2.getSchemaVersion()).isEqualTo((Object)newSchemaVersion);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{NodeStateEvent.added((DefaultNode)((DefaultNode)node2))});
    }

    @Test
    public void should_not_add_existing_node_with_same_id_and_endpoint() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1), Collections.emptyMap(), null);
        DefaultNodeInfo newNodeInfo = DefaultNodeInfo.builder().withHostId(this.node1.getHostId()).withEndPoint(this.node1.getEndPoint()).withDatacenter("dc1").withRack("rack2").build();
        AddNodeRefresh refresh = new AddNodeRefresh((NodeInfo)newNodeInfo);
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getNodes()).containsOnlyKeys((Object[])new UUID[]{this.node1.getHostId()});
        Assertions.assertThat((String)this.node1.getDatacenter()).isNull();
        Assertions.assertThat((String)this.node1.getRack()).isNull();
        Assertions.assertThat((List)result.events).isEmpty();
    }

    @Test
    public void should_add_existing_node_with_same_id_but_different_endpoint() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1), Collections.emptyMap(), null);
        DefaultEndPoint newEndPoint = TestNodeFactory.newEndPoint(2);
        InetSocketAddress newBroadcastRpcAddress = newEndPoint.resolve();
        UUID newSchemaVersion = Uuids.random();
        DefaultNodeInfo newNodeInfo = DefaultNodeInfo.builder().withHostId(this.node1.getHostId()).withEndPoint((EndPoint)newEndPoint).withDatacenter("dc1").withRack("rack2").withSchemaVersion(newSchemaVersion).withBroadcastRpcAddress(newBroadcastRpcAddress).build();
        AddNodeRefresh refresh = new AddNodeRefresh((NodeInfo)newNodeInfo);
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Map newNodes = result.newMetadata.getNodes();
        ((MapAssert)Assertions.assertThat((Map)newNodes).hasSize(1)).containsEntry((Object)this.node1.getHostId(), (Object)this.node1);
        Assertions.assertThat((Object)this.node1.getEndPoint()).isEqualTo((Object)newEndPoint);
        Assertions.assertThat((String)this.node1.getDatacenter()).isEqualTo("dc1");
        Assertions.assertThat((String)this.node1.getRack()).isEqualTo("rack2");
        Assertions.assertThat((Comparable)this.node1.getSchemaVersion()).isEqualTo((Object)newSchemaVersion);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TopologyEvent.suggestUp((InetSocketAddress)newBroadcastRpcAddress)});
    }
}

