/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class DefaultLoadBalancingPolicyTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    protected DefaultNode node1;
    @Mock
    protected DefaultNode node2;
    @Mock
    protected DefaultNode node3;
    @Mock
    protected DefaultNode node4;
    @Mock
    protected DefaultNode node5;
    @Mock
    protected InternalDriverContext context;
    @Mock
    protected DriverConfig config;
    @Mock
    protected DriverExecutionProfile defaultProfile;
    @Mock
    protected LoadBalancingPolicy.DistanceReporter distanceReporter;
    @Mock
    protected Appender<ILoggingEvent> appender;
    @Mock
    protected MetadataManager metadataManager;
    @Captor
    protected ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    protected Logger logger;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getSessionName()).thenReturn((Object)"test");
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getProfile("default")).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, null)).thenReturn((Object)"dc1");
        Mockito.when((Object)this.context.getMetadataManager()).thenReturn((Object)this.metadataManager);
        this.logger = (Logger)LoggerFactory.getLogger(DefaultLoadBalancingPolicy.class);
        this.logger.addAppender(this.appender);
        for (Node node : ImmutableList.of((Object)this.node1, (Object)this.node2, (Object)this.node3, (Object)this.node4, (Object)this.node5)) {
            Mockito.when((Object)node.getDatacenter()).thenReturn((Object)"dc1");
        }
        Mockito.when((Object)this.context.getLocalDatacenter(Mockito.anyString())).thenReturn(null);
    }

    @After
    public void teardown() {
        this.logger.detachAppender(this.appender);
    }
}

