/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicyTestBase;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultLoadBalancingPolicyQueryPlanTest
extends DefaultLoadBalancingPolicyTestBase {
    private static final CqlIdentifier KEYSPACE = CqlIdentifier.fromInternal((String)"ks");
    private static final ByteBuffer ROUTING_KEY = Bytes.fromHexString((String)"0xdeadbeef");
    @Mock
    private Request request;
    @Mock
    private DefaultSession session;
    @Mock
    private Metadata metadata;
    @Mock
    private TokenMap tokenMap;
    private DefaultLoadBalancingPolicy policy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1));
        Mockito.when((Object)this.metadataManager.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getTokenMap()).thenAnswer(invocation -> Optional.of(this.tokenMap));
        this.policy = (DefaultLoadBalancingPolicy)Mockito.spy((Object)((Object)new NonShufflingPolicy((DriverContext)this.context, "default")));
        this.policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3, (Object)UUID.randomUUID(), (Object)this.node4, (Object)UUID.randomUUID(), (Object)this.node5), this.distanceReporter);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5});
    }

    @Test
    public void should_use_round_robin_when_request_has_no_routing_keyspace() {
        Assertions.assertThat((Object)this.request.getKeyspace()).isNull();
        Assertions.assertThat((Object)this.request.getRoutingKeyspace()).isNull();
        this.assertRoundRobinQueryPlans();
        ((Request)Mockito.verify((Object)this.request, (VerificationMode)Mockito.never())).getRoutingKey();
        ((Request)Mockito.verify((Object)this.request, (VerificationMode)Mockito.never())).getRoutingToken();
        ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.never())).getMetadata();
    }

    @Test
    public void should_use_round_robin_when_request_has_no_routing_key_or_token() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Assertions.assertThat((Comparable)this.request.getRoutingKey()).isNull();
        Assertions.assertThat((Comparable)this.request.getRoutingToken()).isNull();
        this.assertRoundRobinQueryPlans();
        ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.never())).getMetadata();
    }

    @Test
    public void should_use_round_robin_when_token_map_absent() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.metadata.getTokenMap()).thenReturn(Optional.empty());
        this.assertRoundRobinQueryPlans();
        ((Metadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.atLeast((int)1))).getTokenMap();
    }

    @Test
    public void should_use_round_robin_when_token_map_returns_no_replicas() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).thenReturn(Collections.emptySet());
        this.assertRoundRobinQueryPlans();
        ((TokenMap)Mockito.verify((Object)this.tokenMap, (VerificationMode)Mockito.atLeast((int)1))).getReplicas(KEYSPACE, ROUTING_KEY);
    }

    private void assertRoundRobinQueryPlans() {
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node5, this.node1});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node1, this.node2});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node1, this.node2, this.node3});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node5, this.node1, this.node2, this.node3, this.node4});
        }
    }

    @Test
    public void should_prioritize_single_replica() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node3));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2, this.node4, this.node5});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node4, this.node5, this.node1});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node1, this.node2});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        ((DefaultLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.never())).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void should_prioritize_and_shuffle_replicas() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node3, (Object)this.node5));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node2, this.node4, this.node1});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node4, this.node1, this.node2});
        ((DefaultLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)3))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
        ((DefaultSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).getPools();
    }

    static class NonShufflingPolicy
    extends DefaultLoadBalancingPolicy {
        NonShufflingPolicy(DriverContext context, String profileName) {
            super(context, profileName);
        }

        protected void shuffleHead(Object[] currentNodes, int replicaCount) {
        }
    }
}

