/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicyTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultLoadBalancingPolicyInitTest
extends DefaultLoadBalancingPolicyTestBase {
    @Test
    public void should_use_local_dc_if_provided_via_config() {
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        Assertions.assertThat((String)policy.localDc).isEqualTo("dc1");
    }

    @Test
    public void should_use_local_dc_if_provided_via_context() {
        Mockito.when((Object)this.context.getLocalDatacenter("default")).thenReturn((Object)"dc1");
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        Assertions.assertThat((String)policy.localDc).isEqualTo("dc1");
        ((DriverExecutionProfile)Mockito.verify((Object)this.defaultProfile, (VerificationMode)Mockito.never())).getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, null);
    }

    @Test
    public void should_infer_local_dc_if_no_explicit_contact_points() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, null)).thenReturn(null);
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1));
        Mockito.when((Object)this.metadataManager.wasImplicitContactPoint()).thenReturn((Object)true);
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1), this.distanceReporter);
        Assertions.assertThat((String)policy.localDc).isEqualTo("dc1");
    }

    @Test
    public void should_require_local_dc_if_explicit_contact_points() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, null)).thenReturn(null);
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node2));
        Mockito.when((Object)this.metadataManager.wasImplicitContactPoint()).thenReturn((Object)false);
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("You provided explicit contact points, the local DC must be specified");
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node2), this.distanceReporter);
    }

    @Test
    public void should_warn_if_contact_points_not_in_local_dc() {
        Mockito.when((Object)this.node2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2, (Object)this.node3));
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((Appender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.atLeast((int)1))).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        List warnLogs = Assertions.filter((Iterable)this.loggingEventCaptor.getAllValues()).with("level", (Object)Level.WARN).get();
        Assertions.assertThat((Iterable)warnLogs).hasSize(1);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((ILoggingEvent)warnLogs.iterator().next()).getFormattedMessage()).contains(new CharSequence[]{"You specified dc1 as the local DC, but some contact points are from a different DC"})).contains(new CharSequence[]{"node2=dc2"})).contains(new CharSequence[]{"node3=dc3"});
    }

    @Test
    public void should_include_nodes_from_local_dc() {
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2));
        Mockito.when((Object)this.node1.getState()).thenReturn((Object)NodeState.UP);
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.DOWN);
        Mockito.when((Object)this.node3.getState()).thenReturn((Object)NodeState.UNKNOWN);
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        Assertions.assertThat((Iterable)policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node3});
    }

    @Test
    public void should_ignore_nodes_from_remote_dcs() {
        Mockito.when((Object)this.node2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2));
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.IGNORED);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1});
    }

    @Test
    public void should_ignore_nodes_excluded_by_filter() {
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2));
        Mockito.when((Object)this.context.getNodeFilter("default")).thenReturn(node -> node.equals(this.node1));
        DefaultLoadBalancingPolicy policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.IGNORED);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1});
    }
}

