/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicyTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultLoadBalancingPolicyEventsTest
extends DefaultLoadBalancingPolicyTestBase {
    @Mock
    private Predicate<Node> filter;
    private DefaultLoadBalancingPolicy policy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.filter.test((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        Mockito.when((Object)this.context.getNodeFilter("default")).thenReturn(this.filter);
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1));
        this.policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default");
        this.policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2), this.distanceReporter);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2});
        Mockito.reset((Object[])new LoadBalancingPolicy.DistanceReporter[]{this.distanceReporter});
    }

    @Test
    public void should_remove_down_node_from_live_set() {
        this.policy.onDown((Node)this.node2);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1});
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter, (VerificationMode)Mockito.never())).setDistance((Node)ArgumentMatchers.eq((Object)this.node2), (NodeDistance)ArgumentMatchers.any(NodeDistance.class));
        ((Predicate)Mockito.verify(this.filter)).test(this.node2);
    }

    @Test
    public void should_remove_removed_node_from_live_set() {
        this.policy.onRemove((Node)this.node2);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1});
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter, (VerificationMode)Mockito.never())).setDistance((Node)ArgumentMatchers.eq((Object)this.node2), (NodeDistance)ArgumentMatchers.any(NodeDistance.class));
        ((Predicate)Mockito.verify(this.filter)).test(this.node2);
    }

    @Test
    public void should_set_added_node_to_local() {
        this.policy.onAdd((Node)this.node3);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        ((Predicate)Mockito.verify(this.filter)).test(this.node3);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2});
    }

    @Test
    public void should_ignore_added_node_when_filtered() {
        Mockito.when((Object)this.filter.test((Node)this.node3)).thenReturn((Object)false);
        this.policy.onAdd((Node)this.node3);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2});
    }

    @Test
    public void should_ignore_added_node_when_remote_dc() {
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc2");
        this.policy.onAdd((Node)this.node3);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2});
    }

    @Test
    public void should_add_up_node_to_live_set() {
        this.policy.onUp((Node)this.node3);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        ((Predicate)Mockito.verify(this.filter)).test(this.node3);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2, this.node3});
    }

    @Test
    public void should_ignore_up_node_when_filtered() {
        Mockito.when((Object)this.filter.test((Node)this.node3)).thenReturn((Object)false);
        this.policy.onUp((Node)this.node3);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        ((Predicate)Mockito.verify(this.filter)).test(this.node3);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2});
    }

    @Test
    public void should_ignore_up_node_when_remote_dc() {
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc2");
        this.policy.onUp((Node)this.node3);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)this.policy.localDcLiveNodes).containsExactlyInAnyOrder((Object[])new Node[]{this.node1, this.node2});
    }
}

