/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.data.IdentifierIndex;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class IdentifierIndexTest {
    private static final CqlIdentifier Foo = CqlIdentifier.fromInternal((String)"Foo");
    private static final CqlIdentifier foo = CqlIdentifier.fromInternal((String)"foo");
    private static final CqlIdentifier fOO = CqlIdentifier.fromInternal((String)"fOO");
    private IdentifierIndex index = new IdentifierIndex((List)ImmutableList.of((Object)Foo, (Object)foo, (Object)fOO));

    @Test
    public void should_find_first_index_of_existing_identifier() {
        Assertions.assertThat((int)this.index.firstIndexOf(Foo)).isEqualTo(0);
        Assertions.assertThat((int)this.index.firstIndexOf(foo)).isEqualTo(1);
        Assertions.assertThat((int)this.index.firstIndexOf(fOO)).isEqualTo(2);
    }

    @Test
    public void should_not_find_index_of_nonexistent_identifier() {
        Assertions.assertThat((int)this.index.firstIndexOf(CqlIdentifier.fromInternal((String)"FOO"))).isEqualTo(-1);
    }

    @Test
    public void should_find_first_index_of_case_insensitive_name() {
        Assertions.assertThat((int)this.index.firstIndexOf("foo")).isEqualTo(0);
    }

    @Test
    public void should_not_find_first_index_of_nonexistent_case_insensitive_name() {
        Assertions.assertThat((int)this.index.firstIndexOf("bar")).isEqualTo(-1);
    }

    @Test
    public void should_find_first_index_of_case_sensitive_name() {
        Assertions.assertThat((int)this.index.firstIndexOf("\"Foo\"")).isEqualTo(0);
        Assertions.assertThat((int)this.index.firstIndexOf("\"foo\"")).isEqualTo(1);
        Assertions.assertThat((int)this.index.firstIndexOf("\"fOO\"")).isEqualTo(2);
    }

    @Test
    public void should_not_find_index_of_nonexistent_case_sensitive_name() {
        Assertions.assertThat((int)this.index.firstIndexOf("\"FOO\"")).isEqualTo(-1);
    }
}

