/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.SerializationHelper;
import com.datastax.oss.driver.internal.core.data.AccessibleByIdTestBase;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultUdtValueTest
extends AccessibleByIdTestBase<UdtValue> {
    @Override
    protected UdtValue newInstance(List<DataType> dataTypes, AttachmentPoint attachmentPoint) {
        UserDefinedTypeBuilder builder = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type"));
        for (int i = 0; i < dataTypes.size(); ++i) {
            builder.withField(CqlIdentifier.fromInternal((String)("field" + i)), dataTypes.get(i));
        }
        UserDefinedType userDefinedType = builder.build();
        userDefinedType.attach(attachmentPoint);
        return userDefinedType.newValue();
    }

    @Override
    protected UdtValue newInstance(List<DataType> dataTypes, List<Object> values, AttachmentPoint attachmentPoint) {
        UserDefinedTypeBuilder builder = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type"));
        for (int i = 0; i < dataTypes.size(); ++i) {
            builder.withField(CqlIdentifier.fromInternal((String)("field" + i)), dataTypes.get(i));
        }
        UserDefinedType userDefinedType = builder.build();
        userDefinedType.attach(attachmentPoint);
        return userDefinedType.newValue(values.toArray());
    }

    @Test
    public void should_serialize_and_deserialize() {
        UserDefinedType type = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), DataTypes.TEXT).build();
        UdtValue in = type.newValue();
        in = (UdtValue)in.setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        in = (UdtValue)in.setBytesUnsafe(1, Bytes.fromHexString((String)"0x61"));
        UdtValue out = SerializationHelper.serializeAndDeserialize(in);
        Assertions.assertThat((Object)out.getType()).isEqualTo((Object)in.getType());
        Assertions.assertThat((boolean)out.getType().isDetached()).isTrue();
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)out.getBytesUnsafe(0))).isEqualTo("0x00000001");
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)out.getBytesUnsafe(1))).isEqualTo("0x61");
    }

    @Test
    public void should_support_null_items_when_setting_in_bulk() throws UnsupportedEncodingException {
        UserDefinedType type = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), DataTypes.TEXT).build();
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT)).thenReturn((Object)TypeCodecs.INT);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, (Object)"foo")).thenReturn((Object)TypeCodecs.TEXT);
        UdtValue value = type.newValue(new Object[]{null, "foo"});
        Assertions.assertThat((boolean)value.isNull(0)).isTrue();
        Assertions.assertThat((String)value.getString(1)).isEqualTo("foo");
    }

    @Test
    public void should_equate_instances_with_same_values_but_different_binary_representations() {
        UserDefinedType type = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"f"), DataTypes.VARINT).build();
        UdtValue udt1 = (UdtValue)type.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x01"));
        UdtValue udt2 = (UdtValue)type.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x0001"));
        Assertions.assertThat((Object)udt1).isEqualTo((Object)udt2);
    }

    @Test
    public void should_format_to_string() {
        UserDefinedType type = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"t"), DataTypes.TEXT).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"d"), DataTypes.DOUBLE).build();
        UdtValue udt = (UdtValue)((UdtValue)type.newValue().setString("t", "foobar")).setDouble("d", 3.14);
        Assertions.assertThat((String)udt.getFormattedContents()).isEqualTo("{t:'foobar',i:NULL,d:3.14}");
    }

    @Test
    public void should_equate_instances_with_different_protocol_versions() {
        UserDefinedType type1 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"t"), DataTypes.TEXT).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"d"), DataTypes.DOUBLE).build();
        type1.attach(this.attachmentPoint);
        UserDefinedType type2 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"t"), DataTypes.TEXT).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"d"), DataTypes.DOUBLE).build();
        type2.attach(this.v3AttachmentPoint);
        UdtValue udt1 = (UdtValue)((UdtValue)((UdtValue)type1.newValue().setString("t", "some text string")).setInt("i", 42)).setDouble("d", 3.14);
        UdtValue udt2 = (UdtValue)((UdtValue)((UdtValue)type2.newValue().setString("t", "some text string")).setInt("i", 42)).setDouble("d", 3.14);
        Assertions.assertThat((Object)udt1).isEqualTo((Object)udt2);
    }
}

