/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.data.SettableByIndex;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CqlIntToStringCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class AccessibleByIndexTestBase<T extends GettableByIndex & SettableByIndex<T>> {
    @Mock
    protected AttachmentPoint attachmentPoint;
    @Mock
    protected AttachmentPoint v3AttachmentPoint;
    @Mock
    protected CodecRegistry codecRegistry;
    protected PrimitiveIntCodec intCodec;
    protected TypeCodec<Double> doubleCodec;
    protected TypeCodec<String> textCodec;

    protected abstract T newInstance(List<DataType> var1, AttachmentPoint var2);

    protected abstract T newInstance(List<DataType> var1, List<Object> var2, AttachmentPoint var3);

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.attachmentPoint.getCodecRegistry()).thenReturn((Object)this.codecRegistry);
        Mockito.when((Object)this.attachmentPoint.getProtocolVersion()).thenReturn((Object)ProtocolVersion.DEFAULT);
        Mockito.when((Object)this.v3AttachmentPoint.getCodecRegistry()).thenReturn((Object)this.codecRegistry);
        Mockito.when((Object)this.v3AttachmentPoint.getProtocolVersion()).thenReturn((Object)DefaultProtocolVersion.V3);
        this.intCodec = (PrimitiveIntCodec)Mockito.spy((Object)TypeCodecs.INT);
        this.doubleCodec = (TypeCodec)Mockito.spy((Object)TypeCodecs.DOUBLE);
        this.textCodec = (TypeCodec)Mockito.spy((Object)TypeCodecs.TEXT);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, Integer.class)).thenAnswer(i -> this.intCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.DOUBLE, Double.class)).thenAnswer(i -> this.doubleCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, String.class)).thenAnswer(i -> this.textCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT)).thenAnswer(i -> this.intCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT)).thenAnswer(t -> this.textCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.DOUBLE)).thenAnswer(d -> this.doubleCodec);
    }

    @Test
    public void should_set_primitive_value_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setInt(0, 1);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, Integer.class);
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).encodePrimitive(1, ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_object_value_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setString(0, "a");
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, String.class);
        ((TypeCodec)Mockito.verify(this.textCodec)).encode((Object)"a", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isEqualTo((Object)Bytes.fromHexString((String)"0x61"));
    }

    @Test
    public void should_set_bytes_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_to_null_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        t = (GettableByIndex)((SettableByIndex)t).setToNull(0);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isNull();
    }

    @Test
    public void should_set_with_explicit_class_by_index() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, String.class)).thenAnswer(i -> intToStringCodec);
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).set(0, (Object)"1", String.class);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, String.class);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_with_explicit_type_by_index() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, GenericType.STRING)).thenAnswer(i -> intToStringCodec);
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).set(0, (Object)"1", GenericType.STRING);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, GenericType.STRING);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_with_explicit_codec_by_index() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).set(0, (Object)"1", (TypeCodec)intToStringCodec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(0)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_values_in_bulk() {
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, (Object)"foo")).thenReturn((Object)TypeCodecs.TEXT);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, (Object)1)).thenReturn((Object)TypeCodecs.INT);
        T t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT, (Object)DataTypes.INT), (List<Object>)ImmutableList.of((Object)"foo", (Object)1), this.attachmentPoint);
        Assertions.assertThat((String)t.getString(0)).isEqualTo("foo");
        Assertions.assertThat((int)t.getInt(1)).isEqualTo(1);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, (Object)"foo");
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, (Object)1);
    }

    @Test
    public void should_set_values_in_bulk_when_not_enough_values() {
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, (Object)"foo")).thenReturn((Object)TypeCodecs.TEXT);
        T t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT, (Object)DataTypes.INT), (List<Object>)ImmutableList.of((Object)"foo"), this.attachmentPoint);
        Assertions.assertThat((String)t.getString(0)).isEqualTo("foo");
        Assertions.assertThat((boolean)t.isNull(1)).isTrue();
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, (Object)"foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_set_values_in_bulk_when_too_many_values() {
        this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT, (Object)DataTypes.INT), (List<Object>)ImmutableList.of((Object)"foo", (Object)1, (Object)"bar"), this.attachmentPoint);
    }

    @Test
    public void should_get_primitive_value_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        int i = t.getInt(0);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, Integer.class);
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).decodePrimitive((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((int)i).isEqualTo(1);
    }

    @Test
    public void should_get_object_value_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x61"));
        String s = t.getString(0);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, String.class);
        ((TypeCodec)Mockito.verify(this.textCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("a");
    }

    @Test
    public void should_get_bytes_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        ByteBuffer bytes = t.getBytesUnsafe(0);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)bytes).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_test_if_null_by_index() {
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, null);
        boolean isNull = t.isNull(0);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((boolean)isNull).isTrue();
    }

    @Test
    public void should_get_with_explicit_class_by_index() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, String.class)).thenAnswer(i -> intToStringCodec);
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)t.get(0, String.class);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, String.class);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_get_with_explicit_type_by_index() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, GenericType.STRING)).thenAnswer(i -> intToStringCodec);
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)t.get(0, GenericType.STRING);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, GenericType.STRING);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_get_with_explicit_codec_by_index() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Object t = this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableByIndex)((SettableByIndex)t).setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)t.get(0, (TypeCodec)intToStringCodec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }
}

