/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.GettableById;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.SettableById;
import com.datastax.oss.driver.api.core.data.SettableByName;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.data.AccessibleByIndexTestBase;
import com.datastax.oss.driver.internal.core.type.codec.CqlIntToStringCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AccessibleByIdTestBase<T extends GettableById & SettableById<T> & SettableByName<T>>
extends AccessibleByIndexTestBase<T> {
    private static final CqlIdentifier FIELD0_ID = CqlIdentifier.fromInternal((String)"field0");
    private static final String FIELD0_NAME = "field0";

    @Test
    public void should_set_primitive_value_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setInt(FIELD0_ID, 1);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, Integer.class);
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).encodePrimitive(1, ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_object_value_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setString(FIELD0_ID, "a");
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, String.class);
        ((TypeCodec)Mockito.verify((Object)this.textCodec)).encode((Object)"a", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isEqualTo((Object)Bytes.fromHexString((String)"0x61"));
    }

    @Test
    public void should_set_bytes_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_to_null_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        t = (GettableById)((SettableById)t).setToNull(FIELD0_ID);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isNull();
    }

    @Test
    public void should_set_with_explicit_class_by_id() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, String.class)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).set(FIELD0_ID, (Object)"1", String.class);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, String.class);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_with_explicit_type_by_id() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, GenericType.STRING)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).set(FIELD0_ID, (Object)"1", GenericType.STRING);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, GenericType.STRING);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_with_explicit_codec_by_id() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).set(FIELD0_ID, (Object)"1", (TypeCodec)intToStringCodec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)t.getBytesUnsafe(FIELD0_ID)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_get_primitive_value_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        int i = t.getInt(FIELD0_ID);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, Integer.class);
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).decodePrimitive((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((int)i).isEqualTo(1);
    }

    @Test
    public void should_get_object_value_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x61"));
        String s = t.getString(FIELD0_ID);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, String.class);
        ((TypeCodec)Mockito.verify((Object)this.textCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("a");
    }

    @Test
    public void should_get_bytes_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        ByteBuffer bytes = t.getBytesUnsafe(FIELD0_ID);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)bytes).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_test_if_null_by_id() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, null);
        boolean isNull = t.isNull(FIELD0_ID);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((boolean)isNull).isTrue();
    }

    @Test
    public void should_get_with_explicit_class_by_id() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, String.class)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)t.get(FIELD0_ID, String.class);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, String.class);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_get_with_explicit_type_by_id() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, GenericType.STRING)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)t.get(FIELD0_ID, GenericType.STRING);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, GenericType.STRING);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_get_with_explicit_codec_by_id() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableById)t).setBytesUnsafe(FIELD0_ID, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)t.get(FIELD0_ID, (TypeCodec)intToStringCodec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_set_primitive_value_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setInt(FIELD0_NAME, 1);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, Integer.class);
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).encodePrimitive(1, ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_object_value_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setString(FIELD0_NAME, "a");
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, String.class);
        ((TypeCodec)Mockito.verify((Object)this.textCodec)).encode((Object)"a", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isEqualTo((Object)Bytes.fromHexString((String)"0x61"));
    }

    @Test
    public void should_set_bytes_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_to_null_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        t = (GettableById)((SettableByName)t).setToNull(FIELD0_NAME);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isNull();
    }

    @Test
    public void should_set_with_explicit_class_by_name() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, String.class)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).set(FIELD0_NAME, (Object)"1", String.class);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, String.class);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_with_explicit_type_by_name() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, GenericType.STRING)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).set(FIELD0_NAME, (Object)"1", GenericType.STRING);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, GenericType.STRING);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_set_with_explicit_codec_by_name() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).set(FIELD0_NAME, (Object)"1", (TypeCodec)intToStringCodec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).encode("1", ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)((GettableByName)t).getBytesUnsafe(FIELD0_NAME)).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_get_primitive_value_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        int i = ((GettableByName)t).getInt(FIELD0_NAME);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, Integer.class);
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).decodePrimitive((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((int)i).isEqualTo(1);
    }

    @Test
    public void should_get_object_value_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.TEXT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x61"));
        String s = ((GettableByName)t).getString(FIELD0_NAME);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.TEXT, String.class);
        ((TypeCodec)Mockito.verify((Object)this.textCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("a");
    }

    @Test
    public void should_get_bytes_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        ByteBuffer bytes = ((GettableByName)t).getBytesUnsafe(FIELD0_NAME);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((Comparable)bytes).isEqualTo((Object)Bytes.fromHexString((String)"0x00000001"));
    }

    @Test
    public void should_test_if_null_by_name() {
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, null);
        boolean isNull = ((GettableByName)t).isNull(FIELD0_NAME);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        Assertions.assertThat((boolean)isNull).isTrue();
    }

    @Test
    public void should_get_with_explicit_class_by_name() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, String.class)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)((GettableByName)t).get(FIELD0_NAME, String.class);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, String.class);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_get_with_explicit_type_by_name() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, GenericType.STRING)).thenAnswer(i -> intToStringCodec);
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)((GettableByName)t).get(FIELD0_NAME, GenericType.STRING);
        ((CodecRegistry)Mockito.verify((Object)this.codecRegistry)).codecFor(DataTypes.INT, GenericType.STRING);
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test
    public void should_get_with_explicit_codec_by_name() {
        CqlIntToStringCodec intToStringCodec = (CqlIntToStringCodec)Mockito.spy((Object)new CqlIntToStringCodec());
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        t = (GettableById)((SettableByName)t).setBytesUnsafe(FIELD0_NAME, Bytes.fromHexString((String)"0x00000001"));
        String s = (String)((GettableByName)t).get(FIELD0_NAME, (TypeCodec)intToStringCodec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.codecRegistry});
        ((CqlIntToStringCodec)Mockito.verify((Object)intToStringCodec)).decode((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ProtocolVersion)ArgumentMatchers.eq((Object)ProtocolVersion.DEFAULT));
        Assertions.assertThat((String)s).isEqualTo("1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_when_id_does_not_exists() {
        CqlIdentifier invalidField = CqlIdentifier.fromInternal((String)"invalidField");
        GettableById t = (GettableById)this.newInstance((List<DataType>)ImmutableList.of((Object)DataTypes.INT), this.attachmentPoint);
        ((SettableById)t).setInt(invalidField, 1);
    }
}

