/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.time.TimestampGenerator;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.CassandraProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinition;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinitions;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.ProtocolConstants;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StatementSizeTest {
    private static final byte[] MOCK_PAGING_STATE = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xdeadbeef"));
    private static final ByteBuffer MOCK_PAYLOAD_VALUE1 = Bytes.fromHexString((String)"0xabcd");
    private static final ByteBuffer MOCK_PAYLOAD_VALUE2 = Bytes.fromHexString((String)"0xef");
    private static final ImmutableMap<String, ByteBuffer> MOCK_PAYLOAD = ImmutableMap.of((Object)"key1", (Object)MOCK_PAYLOAD_VALUE1, (Object)"key2", (Object)MOCK_PAYLOAD_VALUE2);
    private static final byte[] PREPARED_ID = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xaaaa"));
    private static final byte[] RESULT_METADATA_ID = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xbbbb"));
    @Mock
    PreparedStatement preparedStatement;
    @Mock
    InternalDriverContext driverContext;
    @Mock
    DriverConfig config;
    @Mock
    DriverExecutionProfile defaultProfile;
    @Mock
    TimestampGenerator timestampGenerator;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        ByteBuffer preparedId = ByteBuffer.wrap(PREPARED_ID);
        Mockito.when((Object)this.preparedStatement.getId()).thenReturn((Object)preparedId);
        ByteBuffer resultMetadataId = ByteBuffer.wrap(RESULT_METADATA_ID);
        Mockito.when((Object)this.preparedStatement.getResultMetadataId()).thenReturn((Object)resultMetadataId);
        ColumnDefinitions columnDefinitions = DefaultColumnDefinitions.valueOf((List)ImmutableList.of((Object)this.phonyColumnDef("ks", "table", "c1", -1, 9), (Object)this.phonyColumnDef("ks", "table", "c2", -1, 13)));
        Mockito.when((Object)this.preparedStatement.getVariableDefinitions()).thenReturn((Object)columnDefinitions);
        Mockito.when((Object)this.driverContext.getProtocolVersion()).thenReturn((Object)DefaultProtocolVersion.V5);
        Mockito.when((Object)this.driverContext.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        Mockito.when((Object)this.driverContext.getProtocolVersionRegistry()).thenReturn((Object)new CassandraProtocolVersionRegistry(null));
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.driverContext.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.driverContext.getTimestampGenerator()).thenReturn((Object)this.timestampGenerator);
    }

    private ColumnDefinition phonyColumnDef(String keyspace, String table, String column, int index, int typeCode) {
        return new DefaultColumnDefinition(new ColumnSpec(keyspace, table, column, index, (RawType)RawType.PRIMITIVES.get(typeCode)), AttachmentPoint.NONE);
    }

    @Test
    public void should_measure_size_of_simple_statement() {
        String queryString = "SELECT release_version FROM system.local WHERE key = ?";
        SimpleStatement statement = SimpleStatement.newInstance((String)queryString);
        int expectedSize = 9 + (4 + queryString.getBytes(Charsets.UTF_8).length) + 2 + 2 + 4 + 8 + 4;
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize);
        String value1 = "local";
        SimpleStatement statementWithAnonymousValue = SimpleStatement.newInstance((String)queryString, (Object[])new Object[]{value1});
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithAnonymousValue)).isEqualTo(expectedSize + 2 + (4 + value1.getBytes(Charsets.UTF_8).length));
        String key1 = "key";
        SimpleStatement statementWithNamedValue = SimpleStatement.newInstance((String)queryString, (Map)ImmutableMap.of((Object)key1, (Object)value1));
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithNamedValue)).isEqualTo(expectedSize + 2 + (2 + key1.getBytes(Charsets.UTF_8).length) + (4 + value1.getBytes(Charsets.UTF_8).length));
        SimpleStatement statementWithPagingState = (SimpleStatement)statement.setPagingState(ByteBuffer.wrap(MOCK_PAGING_STATE));
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithPagingState)).isEqualTo(expectedSize + 4 + MOCK_PAGING_STATE.length);
        SimpleStatement statementWithPayload = (SimpleStatement)statement.setCustomPayload(MOCK_PAYLOAD);
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithPayload)).isEqualTo(expectedSize + 2 + (2 + "key1".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE1.remaining()) + (2 + "key2".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE2.remaining()));
        SimpleStatement statementWithKeyspace = statement.setKeyspace("testKeyspace");
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithKeyspace)).isEqualTo(expectedSize + 2 + "testKeyspace".getBytes(Charsets.UTF_8).length);
    }

    @Test
    public void should_measure_size_of_bound_statement() {
        BoundStatement statement = this.newBoundStatement(this.preparedStatement, new ByteBuffer[]{ProtocolConstants.UNSET_VALUE, ProtocolConstants.UNSET_VALUE});
        int expectedSize = 25 + (2 + PREPARED_ID.length) + (2 + RESULT_METADATA_ID.length) + 2 + 8 + 4;
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize);
        BoundStatement withValues = (BoundStatement)((BoundStatement)statement.setInt(0, 0)).setString(1, "test");
        Assertions.assertThat((int)this.v5SizeOf((Statement)withValues)).isEqualTo(expectedSize += 4 + "test".getBytes(Charsets.UTF_8).length);
        BoundStatement withPagingState = (BoundStatement)withValues.setPagingState(ByteBuffer.wrap(MOCK_PAGING_STATE));
        Assertions.assertThat((int)this.v5SizeOf((Statement)withPagingState)).isEqualTo(expectedSize += 4 + MOCK_PAGING_STATE.length);
        BoundStatement withPayload = (BoundStatement)withPagingState.setCustomPayload(MOCK_PAYLOAD);
        Assertions.assertThat((int)this.v5SizeOf((Statement)withPayload)).isEqualTo(expectedSize += 2 + (2 + "key1".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE1.remaining()) + (2 + "key2".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE2.remaining()));
    }

    @Test
    public void should_measure_size_of_batch_statement() {
        String queryString = "SELECT release_version FROM system.local";
        String key1 = "key";
        String value1 = "value";
        SimpleStatement statement1 = SimpleStatement.newInstance((String)queryString, (Map)ImmutableMap.of((Object)key1, (Object)value1));
        BoundStatement statement2 = (BoundStatement)((BoundStatement)this.newBoundStatement(this.preparedStatement, new ByteBuffer[]{ProtocolConstants.UNSET_VALUE, ProtocolConstants.UNSET_VALUE}).setInt(0, 0)).setString(1, "test");
        BoundStatement statement3 = (BoundStatement)((BoundStatement)this.newBoundStatement(this.preparedStatement, new ByteBuffer[]{ProtocolConstants.UNSET_VALUE, ProtocolConstants.UNSET_VALUE}).setInt(0, 0)).setString(1, "test2");
        BatchStatement batchStatement = BatchStatement.newInstance((BatchType)DefaultBatchType.UNLOGGED).add((BatchableStatement)statement1).add((BatchableStatement)statement2).add((BatchableStatement)statement3);
        int expectedSize = 13 + (4 + queryString.getBytes(Charsets.UTF_8).length) + 1 + (2 + PREPARED_ID.length) + 1 + (2 + PREPARED_ID.length) + 2 + (2 + key1.getBytes(Charsets.UTF_8).length) + (4 + value1.getBytes(Charsets.UTF_8).length) + (10 + (4 + "test".getBytes(Charsets.UTF_8).length)) + (10 + (4 + "test2".getBytes(Charsets.UTF_8).length)) + 2 + 2 + 8 + 4;
        Assertions.assertThat((int)this.v5SizeOf((Statement)batchStatement)).isEqualTo(expectedSize);
        BatchStatement withPayload = (BatchStatement)batchStatement.setCustomPayload(MOCK_PAYLOAD);
        Assertions.assertThat((int)this.v5SizeOf((Statement)withPayload)).isEqualTo(expectedSize += 2 + (2 + "key1".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE1.remaining()) + (2 + "key2".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE2.remaining()));
    }

    private int v5SizeOf(Statement statement) {
        return statement.computeSizeInBytes((DriverContext)this.driverContext);
    }

    private BoundStatement newBoundStatement(PreparedStatement preparedStatement, ByteBuffer[] initialValues) {
        return new DefaultBoundStatement(preparedStatement, preparedStatement.getVariableDefinitions(), initialValues, null, null, null, null, null, Collections.emptyMap(), null, false, -1L, null, Integer.MIN_VALUE, null, null, null, CodecRegistry.DEFAULT, (ProtocolVersion)DefaultProtocolVersion.V5, null);
    }
}

