/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.time.TimestampGenerator;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.DefaultConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.servererrors.DefaultWriteTypeRegistry;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.throttling.PassThroughRequestThrottler;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.datastax.oss.driver.internal.core.util.concurrent.CapturingTimer;
import com.datastax.oss.protocol.internal.Frame;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.OngoingStubbing;

public class RequestHandlerTestHarness
implements AutoCloseable {
    private final CapturingTimer timer = new CapturingTimer();
    private final Map<Node, ChannelPool> pools;
    @Mock
    protected InternalDriverContext context;
    @Mock
    protected DefaultSession session;
    @Mock
    protected EventLoopGroup eventLoopGroup;
    @Mock
    protected NettyOptions nettyOptions;
    @Mock
    protected DriverConfig config;
    @Mock
    protected DriverExecutionProfile defaultProfile;
    @Mock
    protected LoadBalancingPolicyWrapper loadBalancingPolicyWrapper;
    @Mock
    protected RetryPolicy retryPolicy;
    @Mock
    protected SpeculativeExecutionPolicy speculativeExecutionPolicy;
    @Mock
    protected TimestampGenerator timestampGenerator;
    @Mock
    protected ProtocolVersionRegistry protocolVersionRegistry;
    @Mock
    protected SessionMetricUpdater sessionMetricUpdater;

    public static Builder builder() {
        return new Builder();
    }

    protected RequestHandlerTestHarness(Builder builder) {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.nettyOptions.getTimer()).thenReturn((Object)this.timer);
        Mockito.when((Object)this.nettyOptions.ioEventLoopGroup()).thenReturn((Object)this.eventLoopGroup);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.defaultProfile.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).thenReturn((Object)Duration.ofMillis(500L));
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.LOCAL_ONE.name());
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE)).thenReturn((Object)5000);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.SERIAL.name());
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE)).thenReturn((Object)builder.defaultIdempotence);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.PREPARE_ON_ALL_NODES)).thenReturn((Object)true);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.loadBalancingPolicyWrapper.newQueryPlan((Request)ArgumentMatchers.any(Request.class), ArgumentMatchers.anyString(), (Session)ArgumentMatchers.any(Session.class))).thenReturn((Object)builder.buildQueryPlan());
        Mockito.when((Object)this.context.getLoadBalancingPolicyWrapper()).thenReturn((Object)this.loadBalancingPolicyWrapper);
        Mockito.when((Object)this.context.getRetryPolicy(ArgumentMatchers.anyString())).thenReturn((Object)this.retryPolicy);
        Mockito.when((Object)this.speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Request)ArgumentMatchers.any(Request.class), ArgumentMatchers.anyInt())).thenReturn((Object)-1L);
        Mockito.when((Object)this.context.getSpeculativeExecutionPolicy(ArgumentMatchers.anyString())).thenReturn((Object)this.speculativeExecutionPolicy);
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)new DefaultCodecRegistry("test", new TypeCodec[0]));
        Mockito.when((Object)this.timestampGenerator.next()).thenReturn((Object)Long.MIN_VALUE);
        Mockito.when((Object)this.context.getTimestampGenerator()).thenReturn((Object)this.timestampGenerator);
        this.pools = builder.buildMockPools();
        Mockito.when((Object)this.session.getChannel((Node)ArgumentMatchers.any(Node.class), ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            Node node = (Node)invocation.getArgument(0);
            return this.pools.get(node).next();
        });
        Mockito.when((Object)this.session.getRepreparePayloads()).thenReturn(new ConcurrentHashMap());
        Mockito.when((Object)this.session.setKeyspace((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class))).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.session.getMetricUpdater()).thenReturn((Object)this.sessionMetricUpdater);
        Mockito.when((Object)this.sessionMetricUpdater.isEnabled((Object)((SessionMetric)ArgumentMatchers.any(SessionMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.session.getMetadata()).thenReturn((Object)DefaultMetadata.EMPTY);
        Mockito.when((Object)this.context.getProtocolVersionRegistry()).thenReturn((Object)this.protocolVersionRegistry);
        Mockito.when((Object)this.protocolVersionRegistry.supports((ProtocolVersion)ArgumentMatchers.any(ProtocolVersion.class), (ProtocolFeature)ArgumentMatchers.any(ProtocolFeature.class))).thenReturn((Object)true);
        if (builder.protocolVersion != null) {
            Mockito.when((Object)this.context.getProtocolVersion()).thenReturn((Object)builder.protocolVersion);
        }
        Mockito.when((Object)this.context.getConsistencyLevelRegistry()).thenReturn((Object)new DefaultConsistencyLevelRegistry());
        Mockito.when((Object)this.context.getWriteTypeRegistry()).thenReturn((Object)new DefaultWriteTypeRegistry());
        Mockito.when((Object)this.context.getRequestThrottler()).thenReturn((Object)new PassThroughRequestThrottler((DriverContext)this.context));
        Mockito.when((Object)this.context.getRequestTracker()).thenReturn((Object)new NoopRequestTracker((DriverContext)this.context));
    }

    public DefaultSession getSession() {
        return this.session;
    }

    public InternalDriverContext getContext() {
        return this.context;
    }

    public DriverChannel getChannel(Node node) {
        ChannelPool pool = this.pools.get(node);
        return pool.next();
    }

    public CapturingTimer.CapturedTimeout nextScheduledTimeout() {
        return this.timer.getNextTimeout();
    }

    @Override
    public void close() {
        this.timer.stop();
    }

    public static class Builder {
        private final List<PoolBehavior> poolBehaviors = new ArrayList<PoolBehavior>();
        private boolean defaultIdempotence;
        private ProtocolVersion protocolVersion;

        public Builder withEmptyPool(Node node) {
            this.poolBehaviors.add(new PoolBehavior(node, false));
            return this;
        }

        public Builder withWriteFailure(Node node, Throwable cause) {
            PoolBehavior behavior = new PoolBehavior(node, true);
            behavior.setWriteFailure(cause);
            this.poolBehaviors.add(behavior);
            return this;
        }

        public Builder withResponseFailure(Node node, Throwable cause) {
            PoolBehavior behavior = new PoolBehavior(node, true);
            behavior.setWriteSuccess();
            behavior.setResponseFailure(cause);
            this.poolBehaviors.add(behavior);
            return this;
        }

        public Builder withResponse(Node node, Frame response) {
            PoolBehavior behavior = new PoolBehavior(node, true);
            behavior.setWriteSuccess();
            behavior.setResponseSuccess(response);
            this.poolBehaviors.add(behavior);
            return this;
        }

        public Builder withDefaultIdempotence(boolean defaultIdempotence) {
            this.defaultIdempotence = defaultIdempotence;
            return this;
        }

        public Builder withProtocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public PoolBehavior customBehavior(Node node) {
            PoolBehavior behavior = new PoolBehavior(node, true);
            this.poolBehaviors.add(behavior);
            return behavior;
        }

        public RequestHandlerTestHarness build() {
            return new RequestHandlerTestHarness(this);
        }

        private Queue<Node> buildQueryPlan() {
            ConcurrentLinkedQueue<Node> queryPlan = new ConcurrentLinkedQueue<Node>();
            for (PoolBehavior behavior : this.poolBehaviors) {
                if (queryPlan.contains(behavior.node)) continue;
                queryPlan.offer(behavior.node);
            }
            return queryPlan;
        }

        private Map<Node, ChannelPool> buildMockPools() {
            ConcurrentHashMap<Node, ChannelPool> pools = new ConcurrentHashMap<Node, ChannelPool>();
            HashMap<Node, OngoingStubbing> stubbings = new HashMap<Node, OngoingStubbing>();
            for (PoolBehavior behavior : this.poolBehaviors) {
                Node node = behavior.node;
                ChannelPool pool = pools.computeIfAbsent(node, n -> (ChannelPool)Mockito.mock(ChannelPool.class));
                stubbings.compute(node, (sameNode, previous) -> {
                    if (previous == null) {
                        previous = Mockito.when((Object)pool.next());
                    }
                    return previous.thenReturn((Object)behavior.channel);
                });
            }
            return pools;
        }
    }
}

