/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DefaultSocketChannelConfig;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.CompletableFuture;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PoolBehavior {
    final Node node;
    final DriverChannel channel;
    private final Promise<Void> writePromise;
    private final CompletableFuture<ResponseCallback> callbackFuture = new CompletableFuture();

    public PoolBehavior(Node node, boolean createChannel) {
        this.node = node;
        if (!createChannel) {
            this.channel = null;
            this.writePromise = null;
        } else {
            this.channel = (DriverChannel)Mockito.mock(DriverChannel.class);
            EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
            ChannelConfig config = (ChannelConfig)Mockito.mock(DefaultSocketChannelConfig.class);
            this.writePromise = GlobalEventExecutor.INSTANCE.newPromise();
            Mockito.when((Object)this.channel.write((Message)ArgumentMatchers.any(Message.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class))).thenAnswer(invocation -> {
                ResponseCallback callback = (ResponseCallback)invocation.getArgument(3);
                callback.onStreamIdAssigned(1);
                this.callbackFuture.complete(callback);
                return this.writePromise;
            });
            ChannelFuture closeFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
            Mockito.when((Object)this.channel.closeFuture()).thenReturn((Object)closeFuture);
            Mockito.when((Object)this.channel.eventLoop()).thenReturn((Object)eventLoop);
            Mockito.when((Object)this.channel.config()).thenReturn((Object)config);
        }
    }

    public void verifyWrite() {
        ((DriverChannel)Mockito.verify((Object)this.channel)).write((Message)ArgumentMatchers.any(Message.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
    }

    public void verifyNoWrite() {
        ((DriverChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).write((Message)ArgumentMatchers.any(Message.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
    }

    public void setWriteSuccess() {
        this.writePromise.setSuccess(null);
    }

    public void setWriteFailure(Throwable cause) {
        this.writePromise.setFailure(cause);
    }

    public void setResponseSuccess(Frame responseFrame) {
        this.callbackFuture.thenAccept(callback -> callback.onResponse(responseFrame));
    }

    public void setResponseFailure(Throwable cause) {
        this.callbackFuture.thenAccept(callback -> callback.onFailure(cause));
    }

    public Node getNode() {
        return this.node;
    }

    public DriverChannel getChannel() {
        return this.channel;
    }

    public void mockFollowupRequest(Class<? extends Message> expectedMessage, Frame responseFrame) {
        Promise writePromise2 = GlobalEventExecutor.INSTANCE.newPromise();
        CompletableFuture callbackFuture2 = new CompletableFuture();
        Mockito.when((Object)this.channel.write((Message)ArgumentMatchers.any(expectedMessage), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class))).thenAnswer(invocation -> {
            callbackFuture2.complete((ResponseCallback)invocation.getArgument(3));
            return writePromise2;
        });
        writePromise2.setSuccess(null);
        callbackFuture2.thenAccept(callback -> callback.onResponse(responseFrame));
    }

    public void verifyCancellation() {
        ((DriverChannel)Mockito.verify((Object)this.channel)).cancel((ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
    }
}

