/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.cql.PagingIterableSpliterator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class PagingIterableSpliteratorTest {
    @Test
    @UseDataProvider(value="splitsWithEstimatedSize")
    public void should_split_with_estimated_size(int size, int chunkSize, List<Integer> expectedLeft, List<Integer> expectedRight) {
        PagingIterableSpliterator.Builder builder = PagingIterableSpliterator.builder(PagingIterableSpliteratorTest.iterableOfSize(size)).withEstimatedSize((long)size).withChunkSize(chunkSize);
        PagingIterableSpliterator right = builder.build();
        Spliterator left = right.trySplit();
        Assertions.assertThat((int)right.characteristics()).isEqualTo(17744);
        Assertions.assertThat((long)right.estimateSize()).isEqualTo((long)expectedRight.size());
        Assertions.assertThat((long)right.getExactSizeIfKnown()).isEqualTo((long)expectedRight.size());
        TestConsumer rightConsumer = new TestConsumer();
        right.forEachRemaining((Consumer)rightConsumer);
        Assertions.assertThat((List)rightConsumer.items).containsExactlyElementsOf(expectedRight);
        if (expectedLeft.isEmpty()) {
            Assertions.assertThat((Object)left).isNull();
        } else {
            Assertions.assertThat((int)left.characteristics()).isEqualTo(17744);
            Assertions.assertThat((long)left.estimateSize()).isEqualTo((long)expectedLeft.size());
            Assertions.assertThat((long)left.getExactSizeIfKnown()).isEqualTo((long)expectedLeft.size());
            TestConsumer leftConsumer = new TestConsumer();
            left.forEachRemaining(leftConsumer);
            Assertions.assertThat((List)leftConsumer.items).containsExactlyElementsOf(expectedLeft);
        }
    }

    @DataProvider
    public static Iterable<?> splitsWithEstimatedSize() {
        ArrayList<ArrayList> arguments = new ArrayList<ArrayList>();
        arguments.add(Lists.newArrayList((Object[])new Object[]{0, 1, ImmutableList.of(), ImmutableList.of()}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{1, 1, ImmutableList.of(), ImmutableList.of((Object)0)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{1, 2, ImmutableList.of(), ImmutableList.of((Object)0)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{2, 1, ImmutableList.of((Object)0), ImmutableList.of((Object)1)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 1, ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 5, ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4), ImmutableList.of((Object)5, (Object)6, (Object)7, (Object)8, (Object)9)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 9, ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8), ImmutableList.of((Object)9)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 10, ImmutableList.of(), ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9)}));
        return arguments;
    }

    @Test
    @UseDataProvider(value="splitsWithUnknownSize")
    public void should_split_with_unknown_size(int size, int chunkSize, List<Integer> expectedLeft, List<Integer> expectedRight) {
        PagingIterableSpliterator.Builder builder = PagingIterableSpliterator.builder(PagingIterableSpliteratorTest.iterableOfSize(size)).withChunkSize(chunkSize);
        PagingIterableSpliterator right = builder.build();
        Spliterator left = right.trySplit();
        Assertions.assertThat((int)right.characteristics()).isEqualTo(1296);
        Assertions.assertThat((long)right.estimateSize()).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((long)right.getExactSizeIfKnown()).isEqualTo(-1L);
        TestConsumer rightConsumer = new TestConsumer();
        right.forEachRemaining((Consumer)rightConsumer);
        Assertions.assertThat((List)rightConsumer.items).containsExactlyElementsOf(expectedRight);
        if (expectedLeft.isEmpty()) {
            Assertions.assertThat((Object)left).isNull();
        } else {
            Assertions.assertThat((int)left.characteristics()).isEqualTo(17744);
            Assertions.assertThat((long)left.estimateSize()).isEqualTo((long)expectedLeft.size());
            Assertions.assertThat((long)left.getExactSizeIfKnown()).isEqualTo((long)expectedLeft.size());
            TestConsumer leftConsumer = new TestConsumer();
            left.forEachRemaining(leftConsumer);
            Assertions.assertThat((List)leftConsumer.items).containsExactlyElementsOf(expectedLeft);
        }
    }

    @DataProvider
    public static Iterable<?> splitsWithUnknownSize() {
        ArrayList<ArrayList> arguments = new ArrayList<ArrayList>();
        arguments.add(Lists.newArrayList((Object[])new Object[]{0, 1, ImmutableList.of(), ImmutableList.of()}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{1, 1, ImmutableList.of((Object)0), ImmutableList.of()}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{1, 2, ImmutableList.of((Object)0), ImmutableList.of()}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{2, 1, ImmutableList.of((Object)0), ImmutableList.of((Object)1)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 1, ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 5, ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4), ImmutableList.of((Object)5, (Object)6, (Object)7, (Object)8, (Object)9)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 9, ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8), ImmutableList.of((Object)9)}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10, 10, ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9), ImmutableList.of()}));
        return arguments;
    }

    @Test
    public void should_consume_with_tryAdvance() {
        PagingIterableSpliterator spliterator = new PagingIterableSpliterator(PagingIterableSpliteratorTest.iterableOfSize(10));
        TestConsumer action = new TestConsumer();
        for (int i = 0; i < 20; ++i) {
            spliterator.tryAdvance((Consumer)action);
        }
        Assertions.assertThat((List)action.items).containsExactly((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Test
    public void should_consume_with_forEachRemaining() {
        PagingIterableSpliterator spliterator = new PagingIterableSpliterator(PagingIterableSpliteratorTest.iterableOfSize(10));
        TestConsumer action = new TestConsumer();
        spliterator.forEachRemaining((Consumer)action);
        Assertions.assertThat((List)action.items).containsExactly((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Test
    @UseDataProvider(value="streams")
    public void should_consume_stream(int size, int chunkSize, boolean parallel) {
        PagingIterableSpliterator spliterator = PagingIterableSpliterator.builder(PagingIterableSpliteratorTest.iterableOfSize(size)).withEstimatedSize((long)size).withChunkSize(chunkSize).build();
        long count = StreamSupport.stream(spliterator, parallel).count();
        Assertions.assertThat((long)count).isEqualTo((long)size);
    }

    @DataProvider
    public static Iterable<?> streams() {
        ArrayList<ArrayList> arguments = new ArrayList<ArrayList>();
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 5000, false}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 1000, false}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 9999, false}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 1, false}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 5000, true}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 1000, true}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 9999, true}));
        arguments.add(Lists.newArrayList((Object[])new Object[]{10000, 1, true}));
        return arguments;
    }

    private static MockPagingIterable<Integer> iterableOfSize(int size) {
        return new MockPagingIterable<Integer>(IntStream.range(0, size).boxed().collect(Collectors.toList()).iterator());
    }

    private static class TestConsumer
    implements Consumer<Integer> {
        private final List<Integer> items = new ArrayList<Integer>();

        private TestConsumer() {
        }

        @Override
        public void accept(Integer integer) {
            this.items.add(integer);
        }
    }

    private static class MockPagingIterable<T>
    implements PagingIterable<T> {
        private final Iterator<T> iterator;

        private MockPagingIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @NonNull
        public Iterator<T> iterator() {
            return this.iterator;
        }

        public boolean isFullyFetched() {
            return !this.iterator.hasNext();
        }

        @NonNull
        public ColumnDefinitions getColumnDefinitions() {
            throw new UnsupportedOperationException("irrelevant");
        }

        @NonNull
        public List<ExecutionInfo> getExecutionInfos() {
            throw new UnsupportedOperationException("irrelevant");
        }

        public int getAvailableWithoutFetching() {
            throw new UnsupportedOperationException("irrelevant");
        }

        public boolean wasApplied() {
            throw new UnsupportedOperationException("irrelevant");
        }
    }
}

