/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public abstract class CqlRequestHandlerTestBase {
    protected static final SimpleStatement UNDEFINED_IDEMPOTENCE_STATEMENT = SimpleStatement.newInstance((String)"mock query");
    protected static final SimpleStatement IDEMPOTENT_STATEMENT = ((SimpleStatementBuilder)SimpleStatement.builder((String)"mock query").setIdempotence(Boolean.valueOf(true))).build();
    protected static final SimpleStatement NON_IDEMPOTENT_STATEMENT = ((SimpleStatementBuilder)SimpleStatement.builder((String)"mock query").setIdempotence(Boolean.valueOf(false))).build();
    protected static final InetSocketAddress ADDRESS1 = new InetSocketAddress("127.0.0.1", 9042);
    protected static final InetSocketAddress ADDRESS2 = new InetSocketAddress("127.0.0.2", 9042);
    protected static final InetSocketAddress ADDRESS3 = new InetSocketAddress("127.0.0.3", 9042);
    @Mock
    protected DefaultNode node1;
    @Mock
    protected DefaultNode node2;
    @Mock
    protected DefaultNode node3;
    @Mock
    protected NodeMetricUpdater nodeMetricUpdater1;
    @Mock
    protected NodeMetricUpdater nodeMetricUpdater2;
    @Mock
    protected NodeMetricUpdater nodeMetricUpdater3;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.node1.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater1);
        Mockito.when((Object)this.nodeMetricUpdater1.isEnabled((Object)((NodeMetric)ArgumentMatchers.any(NodeMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.node2.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater2);
        Mockito.when((Object)this.nodeMetricUpdater2.isEnabled((Object)((NodeMetric)ArgumentMatchers.any(NodeMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.node3.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater3);
        Mockito.when((Object)this.nodeMetricUpdater3.isEnabled((Object)((NodeMetric)ArgumentMatchers.any(NodeMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
    }

    protected static Frame defaultFrameOf(Message responseMessage) {
        return Frame.forResponse((int)DefaultProtocolVersion.V4.getCode(), (int)0, null, (Map)Frame.NO_PAYLOAD, Collections.emptyList(), (Message)responseMessage);
    }

    protected static Message singleRow() {
        RowsMetadata metadata = new RowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "message", 0, (RawType)RawType.PRIMITIVES.get(13))), null, new int[0], null);
        ArrayDeque<ImmutableList> data = new ArrayDeque<ImmutableList>();
        data.add(ImmutableList.of((Object)Bytes.fromHexString((String)"0x68656C6C6F2C20776F726C64")));
        return new DefaultRows(metadata, data);
    }

    @DataProvider
    public static Object[][] idempotentConfig() {
        return new Object[][]{{true, UNDEFINED_IDEMPOTENCE_STATEMENT}, {false, IDEMPOTENT_STATEMENT}, {true, IDEMPOTENT_STATEMENT}};
    }

    @DataProvider
    public static Object[][] nonIdempotentConfig() {
        return new Object[][]{{false, UNDEFINED_IDEMPOTENCE_STATEMENT}, {true, NON_IDEMPOTENT_STATEMENT}, {false, NON_IDEMPOTENT_STATEMENT}};
    }

    @DataProvider
    public static Object[][] allIdempotenceConfigs() {
        return TestDataProviders.concat(CqlRequestHandlerTestBase.idempotentConfig(), CqlRequestHandlerTestBase.nonIdempotentConfig());
    }
}

