/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandler;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandlerTestBase;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.util.concurrent.CapturingTimer;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.util.Timeout;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CqlRequestHandlerSpeculativeExecutionTest
extends CqlRequestHandlerTestBase {
    @Test
    @UseDataProvider(value="nonIdempotentConfig")
    public void should_not_schedule_speculative_executions_if_not_idempotent(boolean defaultIdempotence, SimpleStatement statement) {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            Assertions.assertThat((Object)harness.nextScheduledTimeout()).isNotNull();
            Assertions.assertThat((Object)harness.nextScheduledTimeout()).isNull();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{speculativeExecutionPolicy});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_schedule_speculative_executions(boolean defaultIdempotence, SimpleStatement statement) throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior((Node)this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            long secondExecutionDelay = 200L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)2))).thenReturn((Object)secondExecutionDelay);
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)3))).thenReturn((Object)-1L);
            new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            harness.nextScheduledTimeout();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)DefaultNodeMetric.SPECULATIVE_EXECUTIONS, "default");
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution2 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution2.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(secondExecutionDelay);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater2});
            speculativeExecution2.task().run((Timeout)speculativeExecution2);
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater2)).incrementCounter((Object)DefaultNodeMetric.SPECULATIVE_EXECUTIONS, "default");
            node3Behavior.verifyWrite();
            node3Behavior.setWriteSuccess();
            Assertions.assertThat((Object)harness.nextScheduledTimeout()).isNull();
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_not_start_execution_if_result_complete(boolean defaultIdempotence, SimpleStatement statement) throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            CqlRequestHandler requestHandler = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = requestHandler.handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            harness.nextScheduledTimeout();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            node1Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf(CqlRequestHandlerSpeculativeExecutionTest.singleRow()));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
            Assertions.assertThat((boolean)requestHandler.scheduledTimeout.isCancelled()).isTrue();
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node2Behavior.verifyNoWrite();
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_fail_if_no_nodes(boolean defaultIdempotence, SimpleStatement statement) {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            harness.nextScheduledTimeout();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(NoNodeAvailableException.class);
            });
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_fail_if_no_more_nodes_and_initial_execution_is_last(boolean defaultIdempotence, SimpleStatement statement) throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        harnessBuilder.withResponse((Node)this.node2, CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf((Message)new Error(4098, "mock message")));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            harness.nextScheduledTimeout();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node1Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf((Message)new Error(4098, "mock message")));
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map nodeErrors = ((AllNodesFailedException)error).getErrors();
                Assertions.assertThat((Map)nodeErrors).containsOnlyKeys((Object[])new Node[]{this.node1, this.node2});
                Assertions.assertThat((Throwable)((Throwable)nodeErrors.get(this.node1))).isInstanceOf(BootstrappingException.class);
                Assertions.assertThat((Throwable)((Throwable)nodeErrors.get(this.node2))).isInstanceOf(BootstrappingException.class);
            });
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_fail_if_no_more_nodes_and_speculative_execution_is_last(boolean defaultIdempotence, SimpleStatement statement) throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            harness.nextScheduledTimeout();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node1Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf((Message)new Error(4098, "mock message")));
            node2Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf((Message)new Error(4098, "mock message")));
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map nodeErrors = ((AllNodesFailedException)error).getErrors();
                Assertions.assertThat((Map)nodeErrors).containsOnlyKeys((Object[])new Node[]{this.node1, this.node2});
                Assertions.assertThat((Throwable)((Throwable)nodeErrors.get(this.node1))).isInstanceOf(BootstrappingException.class);
                Assertions.assertThat((Throwable)((Throwable)nodeErrors.get(this.node2))).isInstanceOf(BootstrappingException.class);
            });
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_retry_in_speculative_executions(boolean defaultIdempotence, SimpleStatement statement) throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        harnessBuilder.withResponse((Node)this.node3, CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf(CqlRequestHandlerSpeculativeExecutionTest.singleRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            harness.nextScheduledTimeout();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            node2Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf((Message)new Error(4098, "mock message")));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
            node1Behavior.verifyCancellation();
        }
    }

    @Test
    @UseDataProvider(value="idempotentConfig")
    public void should_stop_retrying_other_executions_if_result_complete(boolean defaultIdempotence, SimpleStatement statement) throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior((Node)this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq((Object)statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            harness.nextScheduledTimeout();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            node1Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf(CqlRequestHandlerSpeculativeExecutionTest.singleRow()));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
            node2Behavior.setResponseSuccess(CqlRequestHandlerSpeculativeExecutionTest.defaultFrameOf((Message)new Error(4098, "mock message")));
            node3Behavior.verifyNoWrite();
        }
    }
}

