/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.DefaultWriteType;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.ServerError;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandler;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandlerTestBase;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.error.ReadTimeout;
import com.datastax.oss.protocol.internal.response.error.Unavailable;
import com.datastax.oss.protocol.internal.response.error.WriteTimeout;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CqlRequestHandlerRetryTest
extends CqlRequestHandlerTestBase {
    @Test
    @UseDataProvider(value="allIdempotenceConfigs")
    public void should_always_try_next_node_if_bootstrapping(boolean defaultIdempotence, SimpleStatement statement) {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence).withResponse((Node)this.node1, CqlRequestHandlerRetryTest.defaultFrameOf((Message)new Error(4098, "mock message"))).withResponse((Node)this.node2, CqlRequestHandlerRetryTest.defaultFrameOf(CqlRequestHandlerRetryTest.singleRow())).build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node2);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(1);
                Assertions.assertThat((Object)((Node)((Map.Entry)executionInfo.getErrors().get(0)).getKey())).isEqualTo((Object)this.node1);
                Assertions.assertThat((Throwable)((Throwable)((Map.Entry)executionInfo.getErrors().get(0)).getValue())).isInstanceOf(BootstrappingException.class);
                Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
                Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getContext().getRetryPolicy(ArgumentMatchers.anyString())});
            });
        }
    }

    @Test
    @UseDataProvider(value="allIdempotenceConfigs")
    public void should_always_rethrow_query_validation_error(boolean defaultIdempotence, SimpleStatement statement) {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence).withResponse((Node)this.node1, CqlRequestHandlerRetryTest.defaultFrameOf((Message)new Error(8704, "mock message"))).build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(InvalidQueryException.class)).hasMessage("mock message");
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getContext().getRetryPolicy(ArgumentMatchers.anyString())});
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)DefaultNodeMetric.OTHER_ERRORS, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_try_next_node_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, SimpleStatement statement) {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        harnessBuilder.withResponse((Node)this.node2, CqlRequestHandlerRetryTest.defaultFrameOf(CqlRequestHandlerRetryTest.singleRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyDecision(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryDecision.RETRY_NEXT);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node2);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(1);
                Assertions.assertThat((Object)((Node)((Map.Entry)executionInfo.getErrors().get(0)).getKey())).isEqualTo((Object)this.node1);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.errorMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)DefaultNodeMetric.RETRIES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.retryMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_try_same_node_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, SimpleStatement statement) {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        harnessBuilder.withResponse((Node)this.node1, CqlRequestHandlerRetryTest.defaultFrameOf(CqlRequestHandlerRetryTest.singleRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyDecision(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryDecision.RETRY_SAME);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(1);
                Assertions.assertThat((Object)((Node)((Map.Entry)executionInfo.getErrors().get(0)).getKey())).isEqualTo((Object)this.node1);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.errorMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)DefaultNodeMetric.RETRIES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.retryMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)2))).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)2))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_ignore_error_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, SimpleStatement statement) {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyDecision(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryDecision.IGNORE);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isFalse();
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(0);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.errorMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)DefaultNodeMetric.IGNORES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.ignoreMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_rethrow_error_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, SimpleStatement statement) {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyDecision(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryDecision.RETHROW);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(failureScenario.expectedExceptionClass);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.errorMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndNotIdempotent")
    public void should_rethrow_error_if_not_idempotent_and_error_unsafe_or_policy_rethrows(FailureScenario failureScenario, boolean defaultIdempotence, SimpleStatement statement) {
        boolean shouldCallRetryPolicy = failureScenario.expectedExceptionClass.equals(UnavailableException.class) || failureScenario.expectedExceptionClass.equals(ReadTimeoutException.class);
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        harnessBuilder.withResponse((Node)this.node2, CqlRequestHandlerRetryTest.defaultFrameOf(CqlRequestHandlerRetryTest.singleRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            if (shouldCallRetryPolicy) {
                failureScenario.mockRetryPolicyDecision(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryDecision.RETHROW);
            }
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)statement, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(failureScenario.expectedExceptionClass);
                if (!shouldCallRetryPolicy) {
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getContext().getRetryPolicy(ArgumentMatchers.anyString())});
                }
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)failureScenario.errorMetric, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).isEnabled((Object)DefaultNodeMetric.CQL_MESSAGES, "default");
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @DataProvider
    public static Object[][] failure() {
        return TestDataProviders.fromList(new FailureScenario(ReadTimeoutException.class, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, CqlRequestHandlerTestBase.defaultFrameOf((Message)new ReadTimeout("mock message", 10, 1, 2, true)));
            }

            @Override
            public void mockRetryPolicyDecision(RetryPolicy policy, RetryDecision decision) {
                Mockito.when((Object)policy.onReadTimeout((Request)ArgumentMatchers.any(SimpleStatement.class), (ConsistencyLevel)ArgumentMatchers.eq((Object)DefaultConsistencyLevel.LOCAL_ONE), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((int)0))).thenReturn((Object)decision);
            }
        }, new FailureScenario(WriteTimeoutException.class, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, CqlRequestHandlerTestBase.defaultFrameOf((Message)new WriteTimeout("mock message", 10, 1, 2, "SIMPLE")));
            }

            @Override
            public void mockRetryPolicyDecision(RetryPolicy policy, RetryDecision decision) {
                Mockito.when((Object)policy.onWriteTimeout((Request)ArgumentMatchers.any(SimpleStatement.class), (ConsistencyLevel)ArgumentMatchers.eq((Object)DefaultConsistencyLevel.LOCAL_ONE), (WriteType)ArgumentMatchers.eq((Object)DefaultWriteType.SIMPLE), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)0))).thenReturn((Object)decision);
            }
        }, new FailureScenario(UnavailableException.class, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, CqlRequestHandlerTestBase.defaultFrameOf((Message)new Unavailable("mock message", 10, 2, 1)));
            }

            @Override
            public void mockRetryPolicyDecision(RetryPolicy policy, RetryDecision decision) {
                Mockito.when((Object)policy.onUnavailable((Request)ArgumentMatchers.any(SimpleStatement.class), (ConsistencyLevel)ArgumentMatchers.eq((Object)DefaultConsistencyLevel.LOCAL_ONE), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)0))).thenReturn((Object)decision);
            }
        }, new FailureScenario(ServerError.class, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, CqlRequestHandlerTestBase.defaultFrameOf((Message)new Error(0, "mock server error")));
            }

            @Override
            public void mockRetryPolicyDecision(RetryPolicy policy, RetryDecision decision) {
                Mockito.when((Object)policy.onErrorResponse((Request)ArgumentMatchers.any(SimpleStatement.class), (CoordinatorException)ArgumentMatchers.any(ServerError.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)decision);
            }
        }, new FailureScenario(HeartbeatException.class, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponseFailure(node, (Throwable)Mockito.mock(HeartbeatException.class));
            }

            @Override
            public void mockRetryPolicyDecision(RetryPolicy policy, RetryDecision decision) {
                Mockito.when((Object)policy.onRequestAborted((Request)ArgumentMatchers.any(SimpleStatement.class), (Throwable)ArgumentMatchers.any(HeartbeatException.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)decision);
            }
        });
    }

    @DataProvider
    public static Object[][] failureAndIdempotent() {
        return TestDataProviders.combine(CqlRequestHandlerRetryTest.failure(), CqlRequestHandlerRetryTest.idempotentConfig());
    }

    @DataProvider
    public static Object[][] failureAndNotIdempotent() {
        return TestDataProviders.combine(CqlRequestHandlerRetryTest.failure(), CqlRequestHandlerRetryTest.nonIdempotentConfig());
    }

    private static abstract class FailureScenario {
        private final Class<? extends Throwable> expectedExceptionClass;
        final DefaultNodeMetric errorMetric;
        final DefaultNodeMetric retryMetric;
        final DefaultNodeMetric ignoreMetric;

        protected FailureScenario(Class<? extends Throwable> expectedExceptionClass, DefaultNodeMetric errorMetric, DefaultNodeMetric retryMetric, DefaultNodeMetric ignoreMetric) {
            this.expectedExceptionClass = expectedExceptionClass;
            this.errorMetric = errorMetric;
            this.retryMetric = retryMetric;
            this.ignoreMetric = ignoreMetric;
        }

        abstract void mockRequestError(RequestHandlerTestHarness.Builder var1, Node var2);

        abstract void mockRetryPolicyDecision(RetryPolicy var1, RetryDecision var2);
    }
}

