/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinitions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class ConversionsTest {
    @Test
    public void should_find_pk_indices_if_all_bound() {
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk"), (ColumnDefinitions)this.variables("pk"))).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk"), (ColumnDefinitions)this.variables("pk", "c"))).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk"), (ColumnDefinitions)this.variables("c", "pk"))).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk1", "pk2", "pk3"), (ColumnDefinitions)this.variables("c1", "pk2", "pk3", "c2", "pk1", "c3"))).containsExactly((Object[])new Integer[]{4, 1, 2});
    }

    @Test
    public void should_use_first_pk_index_if_bound_multiple_times() {
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk"), (ColumnDefinitions)this.variables("pk", "pk"))).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk"), (ColumnDefinitions)this.variables("pk", "c1", "pk", "c2"))).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk1", "pk2", "pk3"), (ColumnDefinitions)this.variables("c1", "pk2", "pk3", "c2", "pk1", "c3", "pk1", "pk2"))).containsExactly((Object[])new Integer[]{4, 1, 2});
    }

    @Test
    public void should_return_empty_pk_indices_if_at_least_one_component_not_bound() {
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk"), (ColumnDefinitions)this.variables("c1", "c2"))).isEmpty();
        Assertions.assertThat((List)Conversions.findIndices(this.partitionKey("pk1", "pk2", "pk3"), (ColumnDefinitions)this.variables("c1", "pk2", "c2", "pk1", "c3"))).isEmpty();
    }

    private List<ColumnMetadata> partitionKey(String ... columnNames) {
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)columnNames.length);
        for (String columnName : columnNames) {
            ColumnMetadata column = (ColumnMetadata)Mockito.mock(ColumnMetadata.class);
            Mockito.when((Object)column.getName()).thenReturn((Object)CqlIdentifier.fromInternal((String)columnName));
            columns.add((Object)column);
        }
        return columns.build();
    }

    private ColumnDefinitions variables(String ... columnNames) {
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)columnNames.length);
        for (String columnName : columnNames) {
            ColumnDefinition column = (ColumnDefinition)Mockito.mock(ColumnDefinition.class);
            Mockito.when((Object)column.getName()).thenReturn((Object)CqlIdentifier.fromInternal((String)columnName));
            columns.add((Object)column);
        }
        return DefaultColumnDefinitions.valueOf((List)columns.build());
    }
}

