/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.control;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.MockChannelFactoryHelper;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.control.ControlConnectionTestBase;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DistanceEvent;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class ControlConnectionTest
extends ControlConnectionTestBase {
    @Test
    public void should_close_successfully_if_it_was_never_init() {
        CompletionStage closeFuture = this.controlConnection.forceCloseAsync();
        Assertions.assertThatStage(closeFuture).isSuccess();
    }

    @Test
    public void should_init_with_first_contact_point_if_reachable() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_always_return_same_init_future() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).build();
        CompletionStage initFuture1 = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        CompletionStage initFuture2 = this.controlConnection.init(false, false, false);
        Assertions.assertThatStage(initFuture1).isEqualTo(initFuture2);
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_init_with_second_contact_point_if_first_one_fails() {
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node1, "mock failure").success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess(v -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel2);
        });
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.controlConnectionFailed((Node)this.node1));
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        ((ReconnectionPolicy)Mockito.verify((Object)this.reconnectionPolicy, (VerificationMode)Mockito.never())).newNodeSchedule((Node)ArgumentMatchers.any(Node.class));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_fail_to_init_if_all_contact_points_fail() {
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node1, "mock failure").failure((Node)this.node2, "mock failure").build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isFailed();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.controlConnectionFailed((Node)this.node1));
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.controlConnectionFailed((Node)this.node2));
        ((ReconnectionPolicy)Mockito.verify((Object)this.reconnectionPolicy, (VerificationMode)Mockito.never())).newNodeSchedule((Node)ArgumentMatchers.any(Node.class));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_reconnect_if_channel_goes_down() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).failure((Node)this.node1, "mock failure").success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        channel1.close();
        this.waitForPendingAdminTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        factoryHelper.waitForCall((Node)this.node1);
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel2);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).refreshNodes();
        ((LoadBalancingPolicyWrapper)Mockito.verify((Object)this.loadBalancingPolicyWrapper)).init();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_reconnect_if_node_becomes_ignored() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.mockQueryPlan(new Node[]{this.node2});
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node1));
        this.waitForPendingAdminTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.never())).nextDelay();
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel2);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).refreshNodes();
        ((LoadBalancingPolicyWrapper)Mockito.verify((Object)this.loadBalancingPolicyWrapper)).init();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_reconnect_if_node_is_removed() {
        this.should_reconnect_if_event(NodeStateEvent.removed((DefaultNode)this.node1));
    }

    @Test
    public void should_reconnect_if_node_is_forced_down() {
        this.should_reconnect_if_event(NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.FORCED_DOWN, (DefaultNode)this.node1));
    }

    private void should_reconnect_if_event(NodeStateEvent event) {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.mockQueryPlan(new Node[]{this.node2});
        this.eventBus.fire((Object)event);
        this.waitForPendingAdminTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.never())).nextDelay();
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel2);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).refreshNodes();
        ((LoadBalancingPolicyWrapper)Mockito.verify((Object)this.loadBalancingPolicyWrapper)).init();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_reconnect_if_node_became_ignored_during_reconnection_attempt() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel3 = this.newMockDriverChannel(3);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).pending((Node)this.node2, channel2Future).success((Node)this.node1, channel3).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.mockQueryPlan(new Node[]{this.node2, this.node1});
        channel1.close();
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        factoryHelper.waitForCall((Node)this.node2);
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node2));
        channel2Future.complete(channel2);
        this.waitForPendingAdminTasks();
        ((DriverChannel)Mockito.verify((Object)channel2)).forceClose();
        factoryHelper.waitForCall((Node)this.node1);
    }

    @Test
    public void should_reconnect_if_node_was_removed_during_reconnection_attempt() {
        this.should_reconnect_if_event_during_reconnection_attempt(NodeStateEvent.removed((DefaultNode)this.node2));
    }

    @Test
    public void should_reconnect_if_node_was_forced_down_during_reconnection_attempt() {
        this.should_reconnect_if_event_during_reconnection_attempt(NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.FORCED_DOWN, (DefaultNode)this.node2));
    }

    private void should_reconnect_if_event_during_reconnection_attempt(NodeStateEvent event) {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel3 = this.newMockDriverChannel(3);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).pending((Node)this.node2, channel2Future).success((Node)this.node1, channel3).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.mockQueryPlan(new Node[]{this.node2, this.node1});
        channel1.close();
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        factoryHelper.waitForCall((Node)this.node2);
        this.eventBus.fire((Object)event);
        channel2Future.complete(channel2);
        this.waitForPendingAdminTasks();
        ((DriverChannel)Mockito.verify((Object)channel2)).forceClose();
        factoryHelper.waitForCall((Node)this.node1);
    }

    @Test
    public void should_force_reconnection_if_pending() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofDays(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).failure((Node)this.node1, "mock failure").success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        channel1.close();
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        this.controlConnection.reconnectNow();
        factoryHelper.waitForCall((Node)this.node1);
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel2);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_force_reconnection_even_if_connected() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).failure((Node)this.node1, "mock failure").success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.controlConnection.reconnectNow();
        factoryHelper.waitForCall((Node)this.node1);
        factoryHelper.waitForCall((Node)this.node2);
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel2);
        ((DriverChannel)Mockito.verify((Object)channel1)).forceClose();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_not_force_reconnection_if_not_init() {
        this.controlConnection.reconnectNow();
        this.waitForPendingAdminTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.never())).nextDelay();
    }

    @Test
    public void should_not_force_reconnection_if_closed() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        CompletionStage closeFuture = this.controlConnection.forceCloseAsync();
        Assertions.assertThatStage(closeFuture).isSuccess();
        this.controlConnection.reconnectNow();
        this.waitForPendingAdminTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.never())).nextDelay();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_close_channel_when_closing() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        CompletionStage closeFuture = this.controlConnection.forceCloseAsync();
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(closeFuture).isSuccess();
        ((DriverChannel)Mockito.verify((Object)channel1)).forceClose();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_close_channel_if_closed_during_reconnection() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).failure((Node)this.node1, "mock failure").pending((Node)this.node2, channel2Future).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        channel1.close();
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        factoryHelper.waitForCall((Node)this.node1);
        factoryHelper.waitForCall((Node)this.node2);
        this.controlConnection.forceCloseAsync();
        this.waitForPendingAdminTasks();
        channel2Future.complete(channel2);
        this.waitForPendingAdminTasks();
        ((DriverChannel)Mockito.verify((Object)channel2)).forceClose();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire((Object)ChannelEvent.channelOpened((Node)this.node2));
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire((Object)ChannelEvent.channelClosed((Node)this.node2));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_handle_channel_failure_if_closed_during_reconnection() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel1Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node1, channel1).pending((Node)this.node1, channel1Future).success((Node)this.node2, channel2).build();
        CompletionStage initFuture = this.controlConnection.init(false, false, false);
        factoryHelper.waitForCall((Node)this.node1);
        this.waitForPendingAdminTasks();
        Assertions.assertThatStage(initFuture).isSuccess();
        Assertions.assertThat((Object)this.controlConnection.channel()).isEqualTo((Object)channel1);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        channel1.close();
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        factoryHelper.waitForCall((Node)this.node1);
        this.controlConnection.forceCloseAsync();
        channel1Future.completeExceptionally(new Exception("mock failure"));
        this.waitForPendingAdminTasks();
        factoryHelper.verifyNoMoreCalls();
    }
}

