/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.control;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.EventCallback;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.control.ControlConnectionTestBase;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.TopologyEvent;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.event.SchemaChangeEvent;
import com.datastax.oss.protocol.internal.response.event.StatusChangeEvent;
import com.datastax.oss.protocol.internal.response.event.TopologyChangeEvent;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ControlConnectionEventsTest
extends ControlConnectionTestBase {
    @Test
    public void should_register_for_all_events_if_topology_requested() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(DriverChannelOptions.class);
        Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.eq((Object)this.node1), (DriverChannelOptions)optionsCaptor.capture())).thenReturn(CompletableFuture.completedFuture(channel1));
        this.controlConnection.init(true, false, false);
        this.waitForPendingAdminTasks();
        DriverChannelOptions channelOptions = (DriverChannelOptions)optionsCaptor.getValue();
        Assertions.assertThat((List)channelOptions.eventTypes).containsExactly((Object[])new String[]{"SCHEMA_CHANGE", "STATUS_CHANGE", "TOPOLOGY_CHANGE"});
        Assertions.assertThat((Object)channelOptions.eventCallback).isEqualTo((Object)this.controlConnection);
    }

    @Test
    public void should_register_for_schema_events_only_if_topology_not_requested() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(DriverChannelOptions.class);
        Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.eq((Object)this.node1), (DriverChannelOptions)optionsCaptor.capture())).thenReturn(CompletableFuture.completedFuture(channel1));
        this.controlConnection.init(false, false, false);
        this.waitForPendingAdminTasks();
        DriverChannelOptions channelOptions = (DriverChannelOptions)optionsCaptor.getValue();
        Assertions.assertThat((List)channelOptions.eventTypes).containsExactly((Object[])new String[]{"SCHEMA_CHANGE"});
        Assertions.assertThat((Object)channelOptions.eventCallback).isEqualTo((Object)this.controlConnection);
    }

    @Test
    public void should_process_status_change_events() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(DriverChannelOptions.class);
        Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.eq((Object)this.node1), (DriverChannelOptions)optionsCaptor.capture())).thenReturn(CompletableFuture.completedFuture(channel1));
        this.controlConnection.init(true, false, false);
        this.waitForPendingAdminTasks();
        EventCallback callback = ((DriverChannelOptions)optionsCaptor.getValue()).eventCallback;
        StatusChangeEvent event = new StatusChangeEvent("UP", ADDRESS1);
        callback.onEvent((Message)event);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)TopologyEvent.suggestUp((InetSocketAddress)ADDRESS1));
    }

    @Test
    public void should_process_topology_change_events() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(DriverChannelOptions.class);
        Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.eq((Object)this.node1), (DriverChannelOptions)optionsCaptor.capture())).thenReturn(CompletableFuture.completedFuture(channel1));
        this.controlConnection.init(true, false, false);
        this.waitForPendingAdminTasks();
        EventCallback callback = ((DriverChannelOptions)optionsCaptor.getValue()).eventCallback;
        TopologyChangeEvent event = new TopologyChangeEvent("NEW_NODE", ADDRESS1);
        callback.onEvent((Message)event);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)TopologyEvent.suggestAdded((InetSocketAddress)ADDRESS1));
    }

    @Test
    public void should_process_schema_change_events() {
        DriverChannel channel1 = this.newMockDriverChannel(1);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(DriverChannelOptions.class);
        Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.eq((Object)this.node1), (DriverChannelOptions)optionsCaptor.capture())).thenReturn(CompletableFuture.completedFuture(channel1));
        this.controlConnection.init(false, false, false);
        this.waitForPendingAdminTasks();
        EventCallback callback = ((DriverChannelOptions)optionsCaptor.getValue()).eventCallback;
        SchemaChangeEvent event = new SchemaChangeEvent("CREATED", "FUNCTION", "ks", "fn", (List)ImmutableList.of((Object)"text", (Object)"text"));
        callback.onEvent((Message)event);
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).refreshSchema("ks", false, false);
    }
}

