/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.protocol.internal.request.Startup;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StartupOptionsBuilderTest {
    private DefaultDriverContext defaultDriverContext;
    @Mock
    private DriverConfigLoader configLoader;
    private List<TypeCodec<?>> typeCodecs = Lists.newArrayList();
    @Mock
    private NodeStateListener nodeStateListener;
    @Mock
    private SchemaChangeListener schemaChangeListener;
    @Mock
    private RequestTracker requestTracker;
    private Map<String, String> localDatacenters = Maps.newHashMap();
    private Map<String, Predicate<Node>> nodeFilters = Maps.newHashMap();
    @Mock
    private ClassLoader classLoader;
    @Mock
    private DriverConfig driverConfig;
    @Mock
    private DriverExecutionProfile defaultProfile;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.configLoader.getInitialConfig()).thenReturn((Object)this.driverConfig);
        Mockito.when((Object)this.driverConfig.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
    }

    private void buildDriverContext() {
        this.defaultDriverContext = new DefaultDriverContext(this.configLoader, this.typeCodecs, this.nodeStateListener, this.schemaChangeListener, this.requestTracker, this.localDatacenters, this.nodeFilters, this.classLoader);
    }

    private void assertDefaultStartupOptions(Startup startup) {
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"CQL_VERSION", (Object)"3.0.0");
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"DRIVER_NAME", (Object)Session.OSS_DRIVER_COORDINATES.getName());
        Assertions.assertThat((Map)startup.options).containsKey((Object)"DRIVER_VERSION");
        Version version = Version.parse((String)((String)startup.options.get("DRIVER_VERSION")));
        Assertions.assertThat((Comparable)version).isEqualByComparingTo((Comparable)Session.OSS_DRIVER_COORDINATES.getVersion());
    }

    @Test
    public void should_build_minimal_startup_options() {
        this.buildDriverContext();
        Startup startup = new Startup(this.defaultDriverContext.getStartupOptions());
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"COMPRESSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_build_startup_options_with_compression() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION)).thenReturn((Object)"lz4");
        this.buildDriverContext();
        Startup startup = new Startup(this.defaultDriverContext.getStartupOptions());
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"COMPRESSION", (Object)"lz4");
        this.assertDefaultStartupOptions(startup);
    }
}

