/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.config.typesafe.MockOptions;
import com.datastax.oss.driver.internal.core.config.typesafe.TypesafeDriverConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.HashMap;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TypesafeDriverConfigTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void should_load_minimal_config_with_no_profiles() {
        TypesafeDriverConfig config = this.parse("int1 = 42");
        Assertions.assertThat((DriverConfig)config).hasIntOption(MockOptions.INT1, 42);
    }

    @Test
    public void should_load_config_with_no_profiles_and_optional_values() {
        TypesafeDriverConfig config = this.parse("int1 = 42\n int2 = 43");
        Assertions.assertThat((DriverConfig)config).hasIntOption(MockOptions.INT1, 42);
        Assertions.assertThat((DriverConfig)config).hasIntOption(MockOptions.INT2, 43);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_if_profile_uses_default_name() {
        this.parse("int1 = 42\n profiles { default { int1 = 43 } }");
    }

    @Test
    public void should_inherit_option_in_profile() {
        TypesafeDriverConfig config = this.parse("int1 = 42\n profiles { profile1 { } }");
        Assertions.assertThat((DriverConfig)config).hasIntOption(MockOptions.INT1, 42).hasIntOption("profile1", MockOptions.INT1, 42);
    }

    @Test
    public void should_override_option_in_profile() {
        TypesafeDriverConfig config = this.parse("int1 = 42\n profiles { profile1 { int1 = 43 } }");
        Assertions.assertThat((DriverConfig)config).hasIntOption(MockOptions.INT1, 42).hasIntOption("profile1", MockOptions.INT1, 43);
    }

    @Test
    public void should_create_derived_profile_with_new_option() {
        TypesafeDriverConfig config = this.parse("int1 = 42");
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile derived = (DriverExecutionProfile)base.withInt((DriverOption)MockOptions.INT2, 43);
        Assertions.assertThat((boolean)base.isDefined((DriverOption)MockOptions.INT2)).isFalse();
        Assertions.assertThat((boolean)derived.isDefined((DriverOption)MockOptions.INT2)).isTrue();
        Assertions.assertThat((int)derived.getInt((DriverOption)MockOptions.INT2)).isEqualTo(43);
    }

    @Test
    public void should_create_derived_profile_overriding_option() {
        TypesafeDriverConfig config = this.parse("int1 = 42");
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile derived = (DriverExecutionProfile)base.withInt((DriverOption)MockOptions.INT1, 43);
        Assertions.assertThat((int)base.getInt((DriverOption)MockOptions.INT1)).isEqualTo(42);
        Assertions.assertThat((int)derived.getInt((DriverOption)MockOptions.INT1)).isEqualTo(43);
    }

    @Test
    public void should_create_derived_profile_unsetting_option() {
        TypesafeDriverConfig config = this.parse("int1 = 42\n int2 = 43");
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile derived = (DriverExecutionProfile)base.without((DriverOption)MockOptions.INT2);
        Assertions.assertThat((int)base.getInt((DriverOption)MockOptions.INT2)).isEqualTo(43);
        Assertions.assertThat((boolean)derived.isDefined((DriverOption)MockOptions.INT2)).isFalse();
    }

    @Test
    public void should_fetch_string_map() {
        TypesafeDriverConfig config = this.parse("int1 = 42 \n auth_provider { auth_thing_one= one \n auth_thing_two = two \n auth_thing_three = three}");
        DriverExecutionProfile base = config.getDefaultProfile();
        base.getStringMap((DriverOption)MockOptions.AUTH_PROVIDER);
        Map map = base.getStringMap((DriverOption)MockOptions.AUTH_PROVIDER);
        Assertions.assertThat((int)map.entrySet().size()).isEqualTo(3);
        Assertions.assertThat((String)((String)map.get("auth_thing_one"))).isEqualTo("one");
        Assertions.assertThat((String)((String)map.get("auth_thing_two"))).isEqualTo("two");
        Assertions.assertThat((String)((String)map.get("auth_thing_three"))).isEqualTo("three");
    }

    @Test
    public void should_create_derived_profile_with_string_map() {
        TypesafeDriverConfig config = this.parse("int1 = 42");
        HashMap<String, String> authThingMap = new HashMap<String, String>();
        authThingMap.put("auth_thing_one", "one");
        authThingMap.put("auth_thing_two", "two");
        authThingMap.put("auth_thing_three", "three");
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile mapBase = (DriverExecutionProfile)base.withStringMap((DriverOption)MockOptions.AUTH_PROVIDER, authThingMap);
        Map fetchedMap = mapBase.getStringMap((DriverOption)MockOptions.AUTH_PROVIDER);
        Assertions.assertThat((Map)fetchedMap).isEqualTo(authThingMap);
    }

    @Test
    public void should_reload() {
        TypesafeDriverConfig config = this.parse("int1 = 42\n profiles { profile1 { int1 = 43 } }");
        config.reload(ConfigFactory.parseString((String)"int1 = 44\n profiles { profile1 { int1 = 45 } }"));
        Assertions.assertThat((DriverConfig)config).hasIntOption(MockOptions.INT1, 44).hasIntOption("profile1", MockOptions.INT1, 45);
    }

    @Test
    public void should_update_derived_profiles_after_reloading() {
        TypesafeDriverConfig config = this.parse("int1 = 42\n profiles { profile1 { int1 = 43 } }");
        DriverExecutionProfile derivedFromDefault = (DriverExecutionProfile)config.getDefaultProfile().withInt((DriverOption)MockOptions.INT2, 50);
        DriverExecutionProfile derivedFromProfile1 = (DriverExecutionProfile)config.getProfile("profile1").withInt((DriverOption)MockOptions.INT2, 51);
        config.reload(ConfigFactory.parseString((String)"int1 = 44\n profiles { profile1 { int1 = 45 } }"));
        Assertions.assertThat((int)derivedFromDefault.getInt((DriverOption)MockOptions.INT1)).isEqualTo(44);
        Assertions.assertThat((int)derivedFromDefault.getInt((DriverOption)MockOptions.INT2)).isEqualTo(50);
        Assertions.assertThat((int)derivedFromProfile1.getInt((DriverOption)MockOptions.INT1)).isEqualTo(45);
        Assertions.assertThat((int)derivedFromProfile1.getInt((DriverOption)MockOptions.INT2)).isEqualTo(51);
    }

    @Test
    public void should_enumerate_options() {
        TypesafeDriverConfig config = this.parse("int1 = 42 \nauth_provider { auth_thing_one= one \n auth_thing_two = two \n auth_thing_three = three}\nprofiles { profile1 { int1 = 45 } }");
        Assertions.assertThat((Iterable)config.getDefaultProfile().entrySet()).containsExactly((Object[])new Map.Entry[]{org.assertj.core.api.Assertions.entry((Object)"auth_provider.auth_thing_one", (Object)"one"), org.assertj.core.api.Assertions.entry((Object)"auth_provider.auth_thing_three", (Object)"three"), org.assertj.core.api.Assertions.entry((Object)"auth_provider.auth_thing_two", (Object)"two"), org.assertj.core.api.Assertions.entry((Object)"int1", (Object)42)});
        Assertions.assertThat((Iterable)config.getProfile("profile1").entrySet()).containsExactly((Object[])new Map.Entry[]{org.assertj.core.api.Assertions.entry((Object)"auth_provider.auth_thing_one", (Object)"one"), org.assertj.core.api.Assertions.entry((Object)"auth_provider.auth_thing_three", (Object)"three"), org.assertj.core.api.Assertions.entry((Object)"auth_provider.auth_thing_two", (Object)"two"), org.assertj.core.api.Assertions.entry((Object)"int1", (Object)45)});
    }

    private TypesafeDriverConfig parse(String configString) {
        Config config = ConfigFactory.parseString((String)configString);
        return new TypesafeDriverConfig(config);
    }
}

