/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.channel.StreamIdGenerator;
import org.junit.Test;

public class StreamIdGeneratorTest {
    @Test
    public void should_have_all_available_upon_creation() {
        StreamIdGenerator generator = new StreamIdGenerator(8);
        Assertions.assertThat((int)generator.getAvailableIds()).isEqualTo(8);
    }

    @Test
    public void should_return_available_ids_in_sequence() {
        StreamIdGenerator generator = new StreamIdGenerator(8);
        for (int i = 0; i < 8; ++i) {
            Assertions.assertThat((int)generator.acquire()).isEqualTo(i);
            Assertions.assertThat((int)generator.getAvailableIds()).isEqualTo(7 - i);
        }
    }

    @Test
    public void should_return_minus_one_when_no_id_available() {
        StreamIdGenerator generator = new StreamIdGenerator(8);
        for (int i = 0; i < 8; ++i) {
            generator.acquire();
        }
        Assertions.assertThat((int)generator.getAvailableIds()).isEqualTo(0);
        Assertions.assertThat((int)generator.acquire()).isEqualTo(-1);
    }

    @Test
    public void should_return_previously_released_ids() {
        StreamIdGenerator generator = new StreamIdGenerator(8);
        for (int i = 0; i < 8; ++i) {
            generator.acquire();
        }
        generator.release(7);
        generator.release(2);
        Assertions.assertThat((int)generator.getAvailableIds()).isEqualTo(2);
        Assertions.assertThat((int)generator.acquire()).isEqualTo(2);
        Assertions.assertThat((int)generator.acquire()).isEqualTo(7);
        Assertions.assertThat((int)generator.acquire()).isEqualTo(-1);
    }
}

