/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.connection.ClosedConnectionException;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerTestBase;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.EmbeddedEndPoint;
import com.datastax.oss.driver.internal.core.channel.InFlightHandler;
import com.datastax.oss.driver.internal.core.channel.MockResponseCallback;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.channel.StreamIdGenerator;
import com.datastax.oss.driver.internal.core.channel.WriteCoalescer;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.result.Void;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class DriverChannelTest
extends ChannelHandlerTestBase {
    public static final int SET_KEYSPACE_TIMEOUT_MILLIS = 100;
    private DriverChannel driverChannel;
    private MockWriteCoalescer writeCoalescer;
    @Mock
    private StreamIdGenerator streamIds;

    @Override
    @Before
    public void setup() {
        super.setup();
        MockitoAnnotations.initMocks((Object)this);
        this.channel.pipeline().addLast(new ChannelHandler[]{new InFlightHandler((ProtocolVersion)DefaultProtocolVersion.V3, this.streamIds, Integer.MAX_VALUE, 100L, this.channel.newPromise(), null, "test")});
        this.writeCoalescer = new MockWriteCoalescer();
        this.driverChannel = new DriverChannel((EndPoint)new EmbeddedEndPoint(), (Channel)this.channel, (WriteCoalescer)this.writeCoalescer, (ProtocolVersion)DefaultProtocolVersion.V3);
    }

    @Test
    public void should_wait_for_coalesced_writes_when_closing_gracefully() {
        MockResponseCallback responseCallback = new MockResponseCallback();
        this.driverChannel.write((Message)new Query("test"), false, Frame.NO_PAYLOAD, (ResponseCallback)responseCallback);
        this.assertNoOutboundFrame();
        Future closeFuture = this.driverChannel.close();
        Assertions.assertThat(closeFuture).isNotDone();
        this.assertNoOutboundFrame();
        this.writeCoalescer.triggerFlush();
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame).isNotNull();
        Assertions.assertThat(closeFuture).isNotDone();
        this.writeInboundFrame(requestFrame, (Message)Void.INSTANCE);
        Assertions.assertThat((Object)responseCallback.getLastResponse().message).isEqualTo((Object)Void.INSTANCE);
        Assertions.assertThat(closeFuture).isSuccess();
    }

    @Test
    public void should_wait_for_coalesced_writes_when_closing_forcefully() {
        MockResponseCallback responseCallback = new MockResponseCallback();
        this.driverChannel.write((Message)new Query("test"), false, Frame.NO_PAYLOAD, (ResponseCallback)responseCallback);
        this.assertNoOutboundFrame();
        Future closeFuture = this.driverChannel.forceClose();
        Assertions.assertThat(closeFuture).isNotDone();
        this.assertNoOutboundFrame();
        this.writeCoalescer.triggerFlush();
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame).isNotNull();
        Assertions.assertThat(closeFuture).isSuccess();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)responseCallback.getFailure()).isInstanceOf(ClosedConnectionException.class)).hasMessageContaining("Channel was force-closed");
    }

    private class MockWriteCoalescer
    implements WriteCoalescer {
        private Queue<Map.Entry<Object, ChannelPromise>> messages = new ArrayDeque<Map.Entry<Object, ChannelPromise>>();

        private MockWriteCoalescer() {
        }

        public ChannelFuture writeAndFlush(Channel channel, Object message) {
            Assertions.assertThat((Comparable)channel).isEqualTo((Object)DriverChannelTest.this.channel);
            ChannelPromise writePromise = channel.newPromise();
            this.messages.offer(new AbstractMap.SimpleEntry<Object, ChannelPromise>(message, writePromise));
            return writePromise;
        }

        void triggerFlush() {
            for (Map.Entry entry : this.messages) {
                DriverChannelTest.this.channel.writeAndFlush(entry.getKey(), (ChannelPromise)entry.getValue());
            }
        }
    }
}

