/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.TestResponses;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.HeartbeatHandler;
import com.datastax.oss.driver.internal.core.channel.InFlightHandler;
import com.datastax.oss.driver.internal.core.channel.LocalEndPoint;
import com.datastax.oss.driver.internal.core.channel.PassThroughWriteCoalescer;
import com.datastax.oss.driver.internal.core.channel.ProtocolInitHandler;
import com.datastax.oss.driver.internal.core.channel.StreamIdGenerator;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.protocol.ByteBufPrimitiveCodec;
import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.response.Ready;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public abstract class ChannelFactoryTestBase {
    static final EndPoint SERVER_ADDRESS = new LocalEndPoint(ChannelFactoryTestBase.class.getSimpleName() + "-server");
    private static final int TIMEOUT_MILLIS = 500;
    DefaultEventLoopGroup serverGroup;
    DefaultEventLoopGroup clientGroup;
    @Mock
    InternalDriverContext context;
    @Mock
    DriverConfig driverConfig;
    @Mock
    DriverExecutionProfile defaultProfile;
    @Mock
    NettyOptions nettyOptions;
    @Mock
    ProtocolVersionRegistry protocolVersionRegistry;
    @Mock
    EventBus eventBus;
    @Mock
    Compressor<ByteBuf> compressor;
    private final Exchanger<Frame> requestFrameExchanger = new Exchanger();
    private LocalServerChannel serverAcceptChannel;
    private volatile LocalChannel serverResponseChannel;

    @Before
    public void setup() throws InterruptedException {
        MockitoAnnotations.initMocks((Object)this);
        this.serverGroup = new DefaultEventLoopGroup(1);
        this.clientGroup = new DefaultEventLoopGroup(1);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.driverConfig);
        Mockito.when((Object)this.driverConfig.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.AUTH_PROVIDER_CLASS)).thenReturn((Object)false);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT)).thenReturn((Object)Duration.ofMillis(500L));
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT)).thenReturn((Object)Duration.ofMillis(500L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS)).thenReturn((Object)1);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL)).thenReturn((Object)Duration.ofSeconds(30L));
        Mockito.when((Object)this.context.getProtocolVersionRegistry()).thenReturn((Object)this.protocolVersionRegistry);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.nettyOptions.ioEventLoopGroup()).thenReturn((Object)this.clientGroup);
        Mockito.when((Object)this.nettyOptions.channelClass()).thenAnswer(i -> LocalChannel.class);
        Mockito.when((Object)this.nettyOptions.allocator()).thenReturn((Object)ByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.context.getFrameCodec()).thenReturn((Object)FrameCodec.defaultClient((PrimitiveCodec)new ByteBufPrimitiveCodec(ByteBufAllocator.DEFAULT), (Compressor)Compressor.none()));
        Mockito.when((Object)this.context.getSslHandlerFactory()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        Mockito.when((Object)this.context.getWriteCoalescer()).thenReturn((Object)new PassThroughWriteCoalescer(null));
        Mockito.when((Object)this.context.getCompressor()).thenReturn(this.compressor);
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.serverGroup).channel(LocalServerChannel.class)).localAddress(SERVER_ADDRESS.resolve())).childHandler((ChannelHandler)new ServerInitializer());
        ChannelFuture channelFuture = serverBootstrap.bind().sync();
        this.serverAcceptChannel = (LocalServerChannel)channelFuture.sync().channel();
    }

    protected Frame readOutboundFrame() {
        try {
            return this.requestFrameExchanger.exchange(null, 500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"unexpected interruption while waiting for outbound frame", (Throwable)e);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Timed out reading outbound frame");
        }
        return null;
    }

    protected void writeInboundFrame(Frame requestFrame, Message response) {
        this.writeInboundFrame(requestFrame, response, requestFrame.protocolVersion);
    }

    private void writeInboundFrame(Frame requestFrame, Message response, int protocolVersion) {
        this.serverResponseChannel.writeAndFlush((Object)Frame.forResponse((int)protocolVersion, (int)requestFrame.streamId, null, (Map)Frame.NO_PAYLOAD, Collections.emptyList(), (Message)response));
    }

    protected void completeSimpleChannelInit() {
        Frame requestFrame = this.readOutboundFrame();
        this.writeInboundFrame(requestFrame, (Message)new Ready());
        requestFrame = this.readOutboundFrame();
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("mockClusterName"));
    }

    ChannelFactory newChannelFactory() {
        return new TestChannelFactory(this.context);
    }

    @After
    public void tearDown() throws InterruptedException {
        this.serverAcceptChannel.close();
        this.serverGroup.shutdownGracefully(500L, 1000L, TimeUnit.MILLISECONDS).sync();
        this.clientGroup.shutdownGracefully(500L, 1000L, TimeUnit.MILLISECONDS).sync();
    }

    private static class TestChannelFactory
    extends ChannelFactory {
        private TestChannelFactory(InternalDriverContext internalDriverContext) {
            super(internalDriverContext);
        }

        ChannelInitializer<Channel> initializer(final EndPoint endPoint, final ProtocolVersion protocolVersion, final DriverChannelOptions options, NodeMetricUpdater nodeMetricUpdater, final CompletableFuture<DriverChannel> resultFuture) {
            return new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) throws Exception {
                    try {
                        DriverExecutionProfile defaultProfile = context.getConfig().getDefaultProfile();
                        long setKeyspaceTimeoutMillis = defaultProfile.getDuration((DriverOption)DefaultDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT).toMillis();
                        int maxRequestsPerConnection = defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS);
                        InFlightHandler inFlightHandler = new InFlightHandler(protocolVersion, new StreamIdGenerator(maxRequestsPerConnection), Integer.MAX_VALUE, setKeyspaceTimeoutMillis, channel.newPromise(), null, "test");
                        HeartbeatHandler heartbeatHandler = new HeartbeatHandler(defaultProfile);
                        ProtocolInitHandler initHandler = new ProtocolInitHandler(context, protocolVersion, clusterName, endPoint, options, heartbeatHandler);
                        channel.pipeline().addLast("inflight", (ChannelHandler)inFlightHandler).addLast("init", (ChannelHandler)initHandler);
                    }
                    catch (Throwable t) {
                        resultFuture.completeExceptionally(t);
                    }
                }
            };
        }
    }

    private class ServerInitializer
    extends ChannelInitializer<LocalChannel> {
        private ServerInitializer() {
        }

        protected void initChannel(LocalChannel ch) throws Exception {
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    super.channelRead(ctx, msg);
                    ChannelFactoryTestBase.this.requestFrameExchanger.exchange((Frame)msg);
                }
            }});
            ChannelFactoryTestBase.this.serverResponseChannel = ch;
        }
    }
}

