/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.TestResponses;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.ChannelFactoryTestBase;
import com.datastax.oss.driver.internal.core.channel.ClusterNameMismatchException;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Ready;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class ChannelFactoryClusterNameTest
extends ChannelFactoryTestBase {
    @Test
    public void should_set_cluster_name_from_first_connection() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)false);
        Mockito.when((Object)this.protocolVersionRegistry.highestNonBeta()).thenReturn((Object)DefaultProtocolVersion.V4);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture).isSuccess();
        Assertions.assertThat((String)factory.clusterName).isEqualTo("mockClusterName");
    }

    @Test
    public void should_check_cluster_name_for_next_connections() throws Throwable {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)false);
        Mockito.when((Object)this.protocolVersionRegistry.highestNonBeta()).thenReturn((Object)DefaultProtocolVersion.V4);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture).isSuccess();
        channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture).isSuccess();
        channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("wrongClusterName"));
        Assertions.assertThatStage(channelFuture).isFailed(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(ClusterNameMismatchException.class)).hasMessageContaining("reports cluster name 'wrongClusterName' that doesn't match our cluster name 'mockClusterName'."));
    }
}

