/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.ChannelFactoryTestBase;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.result.Void;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CompletionStage;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChannelFactoryAvailableIdsTest
extends ChannelFactoryTestBase {
    @Mock
    private ResponseCallback responseCallback;

    @Override
    @Before
    public void setup() throws InterruptedException {
        super.setup();
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)"V4");
        Mockito.when((Object)this.protocolVersionRegistry.fromName("V4")).thenReturn((Object)DefaultProtocolVersion.V4);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS)).thenReturn((Object)128);
        Mockito.when((Object)this.responseCallback.isLastResponse((Frame)ArgumentMatchers.any(Frame.class))).thenReturn((Object)true);
    }

    @Test
    public void should_report_available_ids() {
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.builder().build(), (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.completeSimpleChannelInit();
        Assertions.assertThatStage(channelFuture).isSuccess(channel -> {
            Assertions.assertThat((int)channel.getAvailableIds()).isEqualTo(128);
            Future writeFuture = channel.write((Message)new Query("test"), false, Frame.NO_PAYLOAD, this.responseCallback);
            Assertions.assertThat(writeFuture).isSuccess(v -> {
                Assertions.assertThat((int)channel.getAvailableIds()).isEqualTo(127);
                this.writeInboundFrame(this.readOutboundFrame(), (Message)Void.INSTANCE);
                ((ResponseCallback)Mockito.verify((Object)this.responseCallback, (VerificationMode)Mockito.timeout((long)500L))).onResponse((Frame)ArgumentMatchers.any(Frame.class));
                Assertions.assertThat((int)channel.getAvailableIds()).isEqualTo(128);
            });
        });
    }
}

