/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.internal.core.CassandraProtocolVersionRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import org.assertj.core.api.ObjectAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CassandraProtocolVersionRegistryTest {
    private static ProtocolVersion V3 = new MockProtocolVersion(3, false);
    private static ProtocolVersion V4 = new MockProtocolVersion(4, false);
    private static ProtocolVersion V5 = new MockProtocolVersion(5, false);
    private static ProtocolVersion V5_BETA = new MockProtocolVersion(5, true);
    private static ProtocolVersion V10 = new MockProtocolVersion(10, false);
    private static ProtocolVersion V11 = new MockProtocolVersion(11, false);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void should_fail_if_duplicate_version_code() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Duplicate version code: 5 in V5 and V5_BETA");
        new CassandraProtocolVersionRegistry("test", (ProtocolVersion[][])new ProtocolVersion[][]{{V5, V5_BETA}});
    }

    @Test
    public void should_find_version_by_name() {
        CassandraProtocolVersionRegistry versions = new CassandraProtocolVersionRegistry("test", (ProtocolVersion[][])new ProtocolVersion[][]{{V3, V4}});
        Assertions.assertThat((Object)versions.fromName("V3")).isEqualTo((Object)V3);
        Assertions.assertThat((Object)versions.fromName("V4")).isEqualTo((Object)V4);
    }

    @Test
    public void should_downgrade_if_lower_version_available() {
        CassandraProtocolVersionRegistry versions = new CassandraProtocolVersionRegistry("test", (ProtocolVersion[][])new ProtocolVersion[][]{{V3, V4}});
        Optional downgraded = versions.downgrade(V4);
        downgraded.map(version -> (ObjectAssert)Assertions.assertThat((Object)version).isEqualTo((Object)V3)).orElseThrow(AssertionError::new);
    }

    @Test
    public void should_not_downgrade_if_no_lower_version() {
        CassandraProtocolVersionRegistry versions = new CassandraProtocolVersionRegistry("test", (ProtocolVersion[][])new ProtocolVersion[][]{{V3, V4}});
        Optional downgraded = versions.downgrade(V3);
        Assertions.assertThat((boolean)downgraded.isPresent()).isFalse();
    }

    @Test
    public void should_downgrade_across_version_range() {
        CassandraProtocolVersionRegistry versions = new CassandraProtocolVersionRegistry("test", (ProtocolVersion[][])new ProtocolVersion[][]{{V3, V4}, {V10, V11}});
        Optional downgraded = versions.downgrade(V10);
        downgraded.map(version -> (ObjectAssert)Assertions.assertThat((Object)version).isEqualTo((Object)V4)).orElseThrow(AssertionError::new);
    }

    @Test
    public void should_downgrade_skipping_beta_version() {
        CassandraProtocolVersionRegistry versions = new CassandraProtocolVersionRegistry("test", (ProtocolVersion[][])new ProtocolVersion[][]{{V4, V5_BETA}, {V10, V11}});
        Optional downgraded = versions.downgrade(V10);
        downgraded.map(version -> (ObjectAssert)Assertions.assertThat((Object)version).isEqualTo((Object)V4)).orElseThrow(AssertionError::new);
    }

    private static class MockProtocolVersion
    implements ProtocolVersion {
        private final int code;
        private final boolean beta;

        MockProtocolVersion(int code, boolean beta) {
            this.code = code;
            this.beta = beta;
        }

        public int getCode() {
            return this.code;
        }

        @NonNull
        public String name() {
            return "V" + this.code;
        }

        public boolean isBeta() {
            return this.beta;
        }

        public String toString() {
            return this.name() + (this.beta ? "_BETA" : "");
        }
    }
}

