/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.CassandraProtocolVersionRegistry;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Test;
import org.mockito.Mockito;

public class CassandraProtocolVersionRegistryHighestCommonTest {
    private CassandraProtocolVersionRegistry registry = new CassandraProtocolVersionRegistry("test");

    @Test
    public void should_pick_v3_when_at_least_one_node_is_2_1() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode("2.2.1"), (Object)this.mockNode("2.1.0"), (Object)this.mockNode("3.1.9")))).isEqualTo((Object)DefaultProtocolVersion.V3);
    }

    @Test
    public void should_pick_v4_when_all_nodes_are_2_2_or_more() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode("2.2.0"), (Object)this.mockNode("2.2.1"), (Object)this.mockNode("3.1.9")))).isEqualTo((Object)DefaultProtocolVersion.V4);
    }

    @Test
    public void should_treat_rcs_as_next_stable_versions() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode("2.2.1"), (Object)this.mockNode("2.1.0-rc1"), (Object)this.mockNode("3.1.9")))).isEqualTo((Object)DefaultProtocolVersion.V3);
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode("2.2.0-rc2"), (Object)this.mockNode("2.2.1"), (Object)this.mockNode("3.1.9")))).isEqualTo((Object)DefaultProtocolVersion.V4);
    }

    @Test
    public void should_skip_nodes_that_report_null_version() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode(null), (Object)this.mockNode("2.1.0"), (Object)this.mockNode("3.1.9")))).isEqualTo((Object)DefaultProtocolVersion.V3);
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode(null), (Object)this.mockNode(null), (Object)this.mockNode(null)))).isEqualTo((Object)DefaultProtocolVersion.V4);
    }

    @Test
    public void should_use_v4_for_future_cassandra_versions() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode("3.0.0"), (Object)this.mockNode("12.1.5"), (Object)this.mockNode("98.7.22")))).isEqualTo((Object)DefaultProtocolVersion.V4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_if_no_nodes() {
        this.registry.highestCommon(Collections.emptyList());
    }

    private Node mockNode(String cassandraVersion) {
        Node node = (Node)Mockito.mock(Node.class);
        if (cassandraVersion != null) {
            Mockito.when((Object)node.getCassandraVersion()).thenReturn((Object)Version.parse((String)cassandraVersion));
        }
        return node;
    }

    @Test(expected=UnsupportedProtocolVersionException.class)
    public void should_fail_if_pre_2_1_node() {
        this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockNode("3.0.0"), (Object)this.mockNode("2.0.9")));
    }
}

