/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultAsyncResultSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AsyncPagingIterableWrapperTest {
    @Mock
    private ColumnDefinitions columnDefinitions;
    @Mock
    private Statement<?> statement;
    @Mock
    private CqlSession session;
    @Mock
    private InternalDriverContext context;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.columnDefinitions.contains("i")).thenReturn((Object)true);
        ColumnDefinition iDefinition = (ColumnDefinition)Mockito.mock(ColumnDefinition.class);
        Mockito.when((Object)iDefinition.getType()).thenReturn((Object)DataTypes.INT);
        Mockito.when((Object)this.columnDefinitions.get("i")).thenReturn((Object)iDefinition);
        Mockito.when((Object)this.columnDefinitions.firstIndexOf("i")).thenReturn((Object)0);
        Mockito.when((Object)this.columnDefinitions.get(0)).thenReturn((Object)iDefinition);
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        Mockito.when((Object)this.context.getProtocolVersion()).thenReturn((Object)DefaultProtocolVersion.DEFAULT);
    }

    @Test
    public void should_wrap_result_set() throws Exception {
        ExecutionInfo executionInfo1 = this.mockExecutionInfo();
        DefaultAsyncResultSet resultSet1 = new DefaultAsyncResultSet(this.columnDefinitions, executionInfo1, this.mockData(0, 5), this.session, this.context);
        DefaultAsyncResultSet resultSet2 = new DefaultAsyncResultSet(this.columnDefinitions, this.mockExecutionInfo(), this.mockData(5, 10), this.session, this.context);
        ByteBuffer mockPagingState = ByteBuffer.allocate(0);
        Mockito.when((Object)executionInfo1.getPagingState()).thenReturn((Object)mockPagingState);
        Statement mockNextStatement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.statement.copy(mockPagingState)).thenReturn((Object)mockNextStatement);
        Mockito.when((Object)this.session.executeAsync(mockNextStatement)).thenAnswer(invocation -> CompletableFuture.completedFuture(resultSet2));
        MappedAsyncPagingIterable iterable1 = resultSet1.map(row -> row.getInt("i"));
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((Integer)((Integer)iterable1.one())).isEqualTo(i);
            Assertions.assertThat((int)iterable1.remaining()).isEqualTo(resultSet1.remaining()).isEqualTo(4 - i);
        }
        Assertions.assertThat((boolean)iterable1.hasMorePages()).isTrue();
        MappedAsyncPagingIterable iterable2 = (MappedAsyncPagingIterable)iterable1.fetchNextPage().toCompletableFuture().get();
        for (int i = 5; i < 10; ++i) {
            Assertions.assertThat((Integer)((Integer)iterable2.one())).isEqualTo(i);
            Assertions.assertThat((int)iterable2.remaining()).isEqualTo(resultSet2.remaining()).isEqualTo(9 - i);
        }
        Assertions.assertThat((boolean)iterable2.hasMorePages()).isFalse();
    }

    @Test
    public void should_share_iteration_progress_with_wrapped_result_set() {
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.mockExecutionInfo(), this.mockData(0, 10), this.session, this.context);
        MappedAsyncPagingIterable iterable = resultSet.map(row -> row.getInt("i"));
        for (int i = 0; i < 10; ++i) {
            Object element = (i % 2 == 0 ? resultSet : iterable).one();
            Assertions.assertThat((Object)element).isNotNull();
            Assertions.assertThat((int)iterable.remaining()).isEqualTo(resultSet.remaining()).isEqualTo(9 - i);
        }
        Assertions.assertThat((boolean)resultSet.hasMorePages()).isFalse();
        Assertions.assertThat((boolean)iterable.hasMorePages()).isFalse();
    }

    private ExecutionInfo mockExecutionInfo() {
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)executionInfo.getStatement()).thenAnswer(invocation -> this.statement);
        return executionInfo;
    }

    private Queue<List<ByteBuffer>> mockData(int start, int end) {
        ArrayDeque<List<ByteBuffer>> data = new ArrayDeque<List<ByteBuffer>>();
        for (int i = start; i < end; ++i) {
            data.add(Lists.newArrayList((Object[])new ByteBuffer[]{TypeCodecs.INT.encode(Integer.valueOf(i), DefaultProtocolVersion.DEFAULT)}));
        }
        return data;
    }
}

