/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.uuid;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import org.assertj.core.api.AbstractLongAssert;
import org.junit.Test;

public class UuidsTest {
    @Test
    public void should_generate_timestamp_within_10_ms() {
        Uuids.random();
        long start = System.currentTimeMillis();
        UUID uuid = Uuids.timeBased();
        Assertions.assertThat((int)uuid.version()).isEqualTo(1);
        Assertions.assertThat((int)uuid.variant()).isEqualTo(2);
        long timestamp = Uuids.unixTimestamp((UUID)uuid);
        ((AbstractLongAssert)Assertions.assertThat((long)timestamp).as("Generated timestamp should be within 10 ms", new Object[0])).isBetween(Long.valueOf(start), Long.valueOf(start + 10L));
    }

    @Test
    public void should_generate_unique_time_based_uuids() {
        int count = 1000000;
        HashSet<UUID> generated = new HashSet<UUID>(count);
        for (int i = 0; i < count; ++i) {
            generated.add(Uuids.timeBased());
        }
        Assertions.assertThat(generated).hasSize(count);
    }

    @Test
    public void should_generate_unique_time_based_uuids_across_threads() throws Exception {
        int i;
        int threadCount = 10;
        int uuidsPerThread = 10000;
        ConcurrentSkipListSet<UUID> generated = new ConcurrentSkipListSet<UUID>();
        UUIDGenerator[] generators = new UUIDGenerator[threadCount];
        for (i = 0; i < threadCount; ++i) {
            generators[i] = new UUIDGenerator(uuidsPerThread, generated);
        }
        for (i = 0; i < threadCount; ++i) {
            generators[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            generators[i].join();
        }
        Assertions.assertThat(generated).hasSize(threadCount * uuidsPerThread);
    }

    @Test
    public void should_generate_ever_increasing_timestamps() {
        int count = 1000000;
        long previous = 0L;
        for (int i = 0; i < count; ++i) {
            long current = Uuids.timeBased().timestamp();
            Assertions.assertThat((long)current).isGreaterThan(previous);
            previous = current;
        }
    }

    @Test
    public void should_generate_within_bounds_for_given_timestamp() {
        Random random = new Random(System.currentTimeMillis());
        int timestampsCount = 10;
        int uuidsPerTimestamp = 10;
        for (int i = 0; i < timestampsCount; ++i) {
            long timestamp = random.nextInt();
            for (int j = 0; j < uuidsPerTimestamp; ++j) {
                UUID uuid = new UUID(Uuids.makeMsb((long)Uuids.fromUnixTimestamp((long)timestamp)), random.nextLong());
                UuidsTest.assertBetween(uuid, Uuids.startOf((long)timestamp), Uuids.endOf((long)timestamp));
            }
        }
    }

    private static void assertBetween(UUID uuid, UUID lowerBound, UUID upperBound) {
        ByteBuffer uuidBytes = TypeCodecs.UUID.encode((Object)uuid, (ProtocolVersion)DefaultProtocolVersion.V3);
        ByteBuffer lb = TypeCodecs.UUID.encode((Object)lowerBound, (ProtocolVersion)DefaultProtocolVersion.V3);
        ByteBuffer ub = TypeCodecs.UUID.encode((Object)upperBound, (ProtocolVersion)DefaultProtocolVersion.V3);
        Assertions.assertThat((int)UuidsTest.compareTimestampBytes(lb, uuidBytes)).isLessThanOrEqualTo(0);
        Assertions.assertThat((int)UuidsTest.compareTimestampBytes(ub, uuidBytes)).isGreaterThanOrEqualTo(0);
    }

    private static int compareTimestampBytes(ByteBuffer o1, ByteBuffer o2) {
        int o1Pos = o1.position();
        int o2Pos = o2.position();
        int d = (o1.get(o1Pos + 6) & 0xF) - (o2.get(o2Pos + 6) & 0xF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 7) & 0xFF) - (o2.get(o2Pos + 7) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 4) & 0xFF) - (o2.get(o2Pos + 4) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 5) & 0xFF) - (o2.get(o2Pos + 5) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos) & 0xFF) - (o2.get(o2Pos) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 1) & 0xFF) - (o2.get(o2Pos + 1) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 2) & 0xFF) - (o2.get(o2Pos + 2) & 0xFF);
        if (d != 0) {
            return d;
        }
        return (o1.get(o1Pos + 3) & 0xFF) - (o2.get(o2Pos + 3) & 0xFF);
    }

    private static class UUIDGenerator
    extends Thread {
        private final int toGenerate;
        private final Set<UUID> generated;

        UUIDGenerator(int toGenerate, Set<UUID> generated) {
            this.toGenerate = toGenerate;
            this.generated = generated;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.toGenerate; ++i) {
                this.generated.add(Uuids.timeBased());
            }
        }
    }
}

