/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UserDefinedTypeTest {
    private static final UserDefinedType ADDRESS_TYPE = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"test"), CqlIdentifier.fromInternal((String)"address")).withField(CqlIdentifier.fromInternal((String)"street"), DataTypes.TEXT).frozen().build();
    private static final UserDefinedType ACCOUNT_TYPE = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"test"), CqlIdentifier.fromInternal((String)"account")).withField(CqlIdentifier.fromInternal((String)"ID"), DataTypes.TEXT).withField(CqlIdentifier.fromInternal((String)"name"), DataTypes.TEXT).withField(CqlIdentifier.fromInternal((String)"address"), (DataType)ADDRESS_TYPE).withField(CqlIdentifier.fromInternal((String)"frozen_list"), (DataType)DataTypes.frozenListOf((DataType)DataTypes.TEXT)).withField(CqlIdentifier.fromInternal((String)"list_of_map"), (DataType)DataTypes.listOf((DataType)DataTypes.frozenMapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.INT))).build();

    @Test
    public void should_describe_as_cql() {
        Assertions.assertThat((String)ACCOUNT_TYPE.describe(false)).isEqualTo("CREATE TYPE \"test\".\"account\" ( \"ID\" text, \"name\" text, \"address\" frozen<\"test\".\"address\">, \"frozen_list\" frozen<list<text>>, \"list_of_map\" list<frozen<map<text, int>>> );");
    }

    @Test
    public void should_describe_as_pretty_cql() {
        Assertions.assertThat((String)ACCOUNT_TYPE.describe(true)).isEqualTo("CREATE TYPE test.account (\n    \"ID\" text,\n    name text,\n    address frozen<test.address>,\n    frozen_list frozen<list<text>>,\n    list_of_map list<frozen<map<text, int>>>\n);");
    }

    @Test
    public void should_evaluate_equality() {
        Assertions.assertThat((Object)ACCOUNT_TYPE.newValue()).isEqualTo((Object)ACCOUNT_TYPE.newValue());
    }
}

