/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import org.assertj.core.api.Assert;
import org.assertj.core.api.Assertions;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class RetryPolicyTestBase {
    private final RetryPolicy policy;
    @Mock
    private Request request;

    protected RetryPolicyTestBase(RetryPolicy policy) {
        this.policy = policy;
    }

    protected Assert<?, RetryDecision> assertOnReadTimeout(ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        return Assertions.assertThat((Comparable)this.policy.onReadTimeout(this.request, cl, blockFor, received, dataPresent, retryCount));
    }

    protected Assert<?, RetryDecision> assertOnWriteTimeout(ConsistencyLevel cl, WriteType writeType, int blockFor, int received, int retryCount) {
        return Assertions.assertThat((Comparable)this.policy.onWriteTimeout(this.request, cl, writeType, blockFor, received, retryCount));
    }

    protected Assert<?, RetryDecision> assertOnUnavailable(ConsistencyLevel cl, int required, int alive, int retryCount) {
        return Assertions.assertThat((Comparable)this.policy.onUnavailable(this.request, cl, required, alive, retryCount));
    }

    protected Assert<?, RetryDecision> assertOnRequestAborted(Class<? extends Throwable> errorClass, int retryCount) {
        return Assertions.assertThat((Comparable)this.policy.onRequestAborted(this.request, (Throwable)Mockito.mock(errorClass), retryCount));
    }

    protected Assert<?, RetryDecision> assertOnErrorResponse(Class<? extends CoordinatorException> errorClass, int retryCount) {
        return Assertions.assertThat((Comparable)this.policy.onErrorResponse(this.request, (CoordinatorException)Mockito.mock(errorClass), retryCount));
    }
}

