/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver;

import com.datastax.oss.protocol.internal.util.Bytes;
import io.netty.buffer.ByteBuf;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class ByteBufAssert
extends AbstractAssert<ByteBufAssert, ByteBuf> {
    public ByteBufAssert(ByteBuf actual) {
        super((Object)actual, ByteBufAssert.class);
    }

    public ByteBufAssert containsExactly(String hexString) {
        ByteBuf copy = ((ByteBuf)this.actual).duplicate();
        byte[] expectedBytes = Bytes.fromHexString((String)hexString).array();
        byte[] actualBytes = new byte[expectedBytes.length];
        copy.readBytes(actualBytes);
        Assertions.assertThat((byte[])actualBytes).containsExactly(expectedBytes);
        Assertions.assertThat((boolean)copy.isReadable()).isFalse();
        return this;
    }
}

