/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.DseSchemaBuilder;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import org.assertj.core.api.Java6Assertions;
import org.junit.Test;

public class CreateDseFunctionTest {
    @Test
    public void should_not_throw_on_toString_for_CreateFunctionStart() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").toString();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 () CALLED ON NULL INPUT");
    }

    @Test
    public void should_not_throw_on_toString_for_CreateFunctionWithType() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).toString()).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS int");
    }

    @Test
    public void should_not_throw_on_toString_for_CreateFunctionWithLanguage() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).withJavaLanguage().toString()).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java");
    }

    @Test
    public void should_create_function_with_simple_params() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func1").withParameter("param1", DataTypes.INT).calledOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().asQuoted("return Integer.toString(param1);").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func1 (param1 int) CALLED ON NULL INPUT RETURNS text LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_create_function_with_param_and_return_type_not_frozen() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func6").withParameter("param1", (DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.INT})).returnsNullOnNull().returnsType((DataType)SchemaBuilder.udt((String)"person", (boolean)true)).withJavaLanguage().as("'return Integer.toString(param1);'").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func6 (param1 tuple<int, int>) RETURNS NULL ON NULL INPUT RETURNS person LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_honor_returns_null() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func2").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().asQuoted("return Integer.toString(param1);").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func2 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_create_function_with_many_params() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func3").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.TEXT).withParameter("param3", DataTypes.BOOLEAN).returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().asQuoted("return Integer.toString(param1);").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func3 (param1 int,param2 text,param3 boolean) RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_create_function_with_no_params() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func4").returnsNullOnNull().returnsType(DataTypes.TEXT).withLanguage("java").asQuoted("return \"hello world\";").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func4 () RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return \"hello world\";'");
    }

    @Test
    public void should_create_function_with_no_keyspace() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"func5").returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().asQuoted("return \"hello world\";").asCql()).isEqualTo((Object)"CREATE FUNCTION func5 () RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return \"hello world\";'");
    }

    @Test
    public void should_create_function_with_if_not_exists() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func6").ifNotExists().returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().asQuoted("return \"hello world\";").asCql()).isEqualTo((Object)"CREATE FUNCTION IF NOT EXISTS keyspace1.func6 () RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return \"hello world\";'");
    }

    @Test
    public void should_create_or_replace() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func6").orReplace().withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().asQuoted("return Integer.toString(param1);").asCql()).isEqualTo((Object)"CREATE OR REPLACE FUNCTION keyspace1.func6 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_not_quote_body_using_as() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func6").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaLanguage().as("'return Integer.toString(param1);'").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func6 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_quote_with_dollar_signs_on_asQuoted_if_body_contains_single_quote() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseFunction((String)"keyspace1", (String)"func6").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).withJavaScriptLanguage().asQuoted("'hello ' + param1;").asCql()).isEqualTo((Object)"CREATE FUNCTION keyspace1.func6 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE javascript AS $$ 'hello ' + param1; $$");
    }

    @Test
    public void should_not_throw_on_toString_for_create_function_with_deterministic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).deterministic().toString();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS int DETERMINISTIC");
    }

    @Test
    public void should_not_quote_body_using_as_with_deterministic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).deterministic().withJavaLanguage().as("'return Integer.toString(param1);'").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text DETERMINISTIC LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_quote_with_dollar_signs_on_asQuoted_if_body_contains_single_quote_with_deterministic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).deterministic().withJavaScriptLanguage().asQuoted("'hello ' + param1;").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text DETERMINISTIC LANGUAGE javascript AS $$ 'hello ' + param1; $$");
    }

    @Test
    public void should_not_throw_on_toString_for_create_function_with_monotonic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).monotonic().toString();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS int MONOTONIC");
    }

    @Test
    public void should_not_quote_body_using_as_with_monotonic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).monotonic().withJavaLanguage().as("'return Integer.toString(param1);'").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text MONOTONIC LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_quote_with_dollar_signs_on_asQuoted_if_body_contains_single_quote_with_monotonic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).monotonic().withJavaScriptLanguage().asQuoted("'hello ' + param1;").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text MONOTONIC LANGUAGE javascript AS $$ 'hello ' + param1; $$");
    }

    @Test
    public void should_not_throw_on_toString_for_create_function_with_monotonic_on() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).monotonicOn("param2").toString();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int,param2 int) RETURNS NULL ON NULL INPUT RETURNS int MONOTONIC ON param2");
    }

    @Test
    public void should_not_quote_body_using_as_with_monotonic_on() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).monotonicOn("param2").withJavaLanguage().as("'return Integer.toString(param1);'").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int,param2 int) RETURNS NULL ON NULL INPUT RETURNS text MONOTONIC ON param2 LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_quote_with_dollar_signs_on_asQuoted_if_body_contains_single_quote_with_monotonic_on() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).monotonicOn("param2").withJavaScriptLanguage().asQuoted("'hello ' + param1;").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int,param2 int) RETURNS NULL ON NULL INPUT RETURNS text MONOTONIC ON param2 LANGUAGE javascript AS $$ 'hello ' + param1; $$");
    }

    @Test
    public void should_not_throw_on_toString_for_create_function_with_deterministic_and_monotonic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).deterministic().monotonic().toString();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS int DETERMINISTIC MONOTONIC");
    }

    @Test
    public void should_not_quote_body_using_as_with_deterministic_and_monotonic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).deterministic().monotonic().withJavaLanguage().as("'return Integer.toString(param1);'").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text DETERMINISTIC MONOTONIC LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_quote_with_dollar_signs_on_asQuoted_if_body_contains_single_quote_with_deterministic_and_monotonic() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).deterministic().monotonic().withJavaScriptLanguage().asQuoted("'hello ' + param1;").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int) RETURNS NULL ON NULL INPUT RETURNS text DETERMINISTIC MONOTONIC LANGUAGE javascript AS $$ 'hello ' + param1; $$");
    }

    @Test
    public void should_not_throw_on_toString_for_create_function_with_deterministic_and_monotonic_on() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.INT).deterministic().monotonicOn("param2").toString();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int,param2 int) RETURNS NULL ON NULL INPUT RETURNS int DETERMINISTIC MONOTONIC ON param2");
    }

    @Test
    public void should_not_quote_body_using_as_with_deterministic_and_monotonic_on() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).deterministic().monotonicOn("param2").withJavaLanguage().as("'return Integer.toString(param1);'").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int,param2 int) RETURNS NULL ON NULL INPUT RETURNS text DETERMINISTIC MONOTONIC ON param2 LANGUAGE java AS 'return Integer.toString(param1);'");
    }

    @Test
    public void should_quote_with_dollar_signs_on_asQuoted_if_body_contains_single_quote_with_deterministic_and_monotonic_on() {
        String funcStr = DseSchemaBuilder.createDseFunction((String)"func1").withParameter("param1", DataTypes.INT).withParameter("param2", DataTypes.INT).returnsNullOnNull().returnsType(DataTypes.TEXT).deterministic().monotonicOn("param2").withJavaScriptLanguage().asQuoted("'hello ' + param1;").asCql();
        Java6Assertions.assertThat((String)funcStr).isEqualTo((Object)"CREATE FUNCTION func1 (param1 int,param2 int) RETURNS NULL ON NULL INPUT RETURNS text DETERMINISTIC MONOTONIC ON param2 LANGUAGE javascript AS $$ 'hello ' + param1; $$");
    }
}

