/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.DseSchemaBuilder;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import org.assertj.core.api.Java6Assertions;
import org.junit.Test;

public class CreateDseAggregateTest {
    @Test
    public void should_create_aggreate_with_simple_param() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"keyspace1", (String)"agg1").withParameter(DataTypes.INT).withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE AGGREGATE keyspace1.agg1 (int) SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_create_aggregate_with_many_params() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"keyspace1", (String)"agg2").withParameter(DataTypes.INT).withParameter(DataTypes.TEXT).withParameter(DataTypes.BOOLEAN).withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE AGGREGATE keyspace1.agg2 (int,text,boolean) SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_create_aggregate_with_param_without_frozen() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"keyspace1", (String)"agg9").withParameter((DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT})).withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE AGGREGATE keyspace1.agg9 (tuple<text>) SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_create_aggregate_with_no_params() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"keyspace1", (String)"agg3").withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE AGGREGATE keyspace1.agg3 () SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_create_aggregate_with_no_keyspace() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"agg4").withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE AGGREGATE agg4 () SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_create_aggregate_with_if_not_exists() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"agg6").ifNotExists().withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE AGGREGATE IF NOT EXISTS agg6 () SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_create_aggregate_with_no_final_func() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"cycling", (String)"sum").withParameter(DataTypes.INT).withSFunc("dsum").withSType(DataTypes.INT).asCql()).isEqualTo((Object)"CREATE AGGREGATE cycling.sum (int) SFUNC dsum STYPE int");
    }

    @Test
    public void should_create_or_replace() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"keyspace1", (String)"agg7").orReplace().withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).asCql()).isEqualTo((Object)"CREATE OR REPLACE AGGREGATE keyspace1.agg7 () SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0)");
    }

    @Test
    public void should_not_throw_on_toString_for_CreateAggregateStart() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"agg1").toString()).isEqualTo((Object)"CREATE AGGREGATE agg1 ()");
    }

    @Test
    public void should_not_throw_on_toString_for_CreateAggregateWithParam() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"func1").withParameter(DataTypes.INT).toString()).isEqualTo((Object)"CREATE AGGREGATE func1 (int)");
    }

    @Test
    public void should_not_throw_on_toString_for_NotExists_OrReplace() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"func1").ifNotExists().orReplace().toString()).isEqualTo((Object)"CREATE OR REPLACE AGGREGATE IF NOT EXISTS func1 ()");
    }

    @Test
    public void should_create_aggregate_with_deterministic() {
        Java6Assertions.assertThat((String)DseSchemaBuilder.createDseAggregate((String)"keyspace1", (String)"agg1").withParameter(DataTypes.INT).withSFunc("sfunction").withSType(DataTypes.ASCII).withFinalFunc("finalfunction").withInitCond(QueryBuilder.tuple((Term[])new Term[]{QueryBuilder.literal((Object)0), QueryBuilder.literal((Object)0)})).deterministic().asCql()).isEqualTo((Object)"CREATE AGGREGATE keyspace1.agg1 (int) SFUNC sfunction STYPE ascii FINALFUNC finalfunction INITCOND (0,0) DETERMINISTIC");
    }
}

