/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.search;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.dse.search.DateRange;
import java.text.ParseException;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateRangeTest {
    @Test(groups={"unit"}, dataProvider="parseAndFormat")
    public void should_parse_and_format(String source) throws ParseException {
        DateRange parsed = DateRange.parse((String)source);
        Assertions.assertThat((String)parsed.toString()).isEqualTo((Object)source);
    }

    @Test(groups={"unit"})
    public void should_use_proleptic_parser() throws ParseException {
        DateRange parsed = DateRange.parse((String)"[0000 TO 0000-01-02]");
        Assertions.assertThat((long)parsed.getLowerBound().getTimestamp().getTime()).isEqualTo(LocalDate.fromYearMonthDay((int)0, (int)1, (int)1).getMillisSinceEpoch());
    }

    @DataProvider
    private Object[][] parseAndFormat() {
        return new Object[][]{{"[2011-01 TO 2015]"}, {"[2010-01-02 TO 2015-05-05T13]"}, {"[1973-06-30T13:57:28.123Z TO 1999-05-05T14:14:59]"}, {"[2010-01-01T15 TO 2016-02]"}, {"[1500 TO 1501]"}, {"[0001 TO 0001-01-02]"}, {"[0000 TO 0000-01-02]"}, {"[-0001 TO -0001-01-02]"}, {"[* TO 2014-12-01]"}, {"[1999 TO *]"}, {"[* TO *]"}, {"0001-01-01"}, {"-0001-01-01"}, {"-0009"}, {"2000-11"}, {"*"}};
    }

    @Test(groups={"unit"})
    public void should_not_parse_and_format_invalid_strings() {
        this.parseAndCheckException("foo", 0);
        this.parseAndCheckException("[foo TO *]", 1);
        this.parseAndCheckException("[* TO foo]", 6);
    }

    private void parseAndCheckException(String source, int index) {
        try {
            DateRange.parse((String)source);
            Assertions.fail((String)"Expected DateTimeParseException");
        }
        catch (ParseException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{source});
            Assertions.assertThat((int)e.getErrorOffset()).isEqualTo(index);
        }
    }

    @Test(groups={"unit"})
    public void should_not_parse_inverted_range() {
        try {
            DateRange.parse((String)"[2001-01 TO 2000]");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Lower bound of a date range should be before upper bound, got: [2001-01 TO 2000]");
        }
    }

    @Test(groups={"unit"})
    public void should_round_up() throws ParseException {
        Date timestamp = ParseUtils.parseDate((String)"2011-02-03T04:05:16.789Z");
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.MILLISECOND.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:05:16.789Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.SECOND.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:05:16.999Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.MINUTE.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:05:59.999Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.HOUR.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:59:59.999Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.DAY.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T23:59:59.999Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.MONTH.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-28T23:59:59.999Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.YEAR.roundUp(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-12-31T23:59:59.999Z"));
    }

    @Test(groups={"unit"})
    public void should_round_down() throws ParseException {
        Date timestamp = ParseUtils.parseDate((String)"2011-02-03T04:05:16.789Z");
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.MILLISECOND.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:05:16.789Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.SECOND.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:05:16.000Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.MINUTE.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:05:00.000Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.HOUR.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T04:00:00.000Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.DAY.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-03T00:00:00.000Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.MONTH.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-02-01T00:00:00.000Z"));
        Assertions.assertThat((Date)DateRange.DateRangeBound.Precision.YEAR.roundDown(timestamp)).isEqualTo((Object)ParseUtils.parseDate((String)"2011-01-01T00:00:00.000Z"));
    }

    @Test(groups={"unit"})
    public void should_not_equate_single_date_open_to_both_open_range() throws ParseException {
        Assertions.assertThat((Object)DateRange.parse((String)"*")).isNotEqualTo((Object)DateRange.parse((String)"[* TO *]"));
    }

    @Test(groups={"unit"})
    public void should_not_equate_same_ranges_with_different_precisions() throws ParseException {
        Assertions.assertThat((Object)DateRange.parse((String)"[2001 TO 2002]")).isNotEqualTo((Object)DateRange.parse((String)"[2001-01 TO 2002-12]"));
    }

    @Test(groups={"unit"})
    public void should_give_same_hashcode_to_equal_objects() throws ParseException {
        Assertions.assertThat((int)DateRange.parse((String)"[2001 TO 2002]").hashCode()).isEqualTo(DateRange.parse((String)"[2001 TO 2002]").hashCode());
    }
}

