/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.search;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.search.DateRange;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.iterable.Extractor;
import org.testng.annotations.Test;

@DseVersion(value="5.1")
public class DateRangeIntegrationTest
extends CCMDseTestsSupport {
    @Test(groups={"short"})
    public void should_use_date_range_as_primary_key() throws Exception {
        this.execute("CREATE TABLE dateRangeIntegrationTest1 (k 'DateRangeType' PRIMARY KEY, v int)", "INSERT INTO dateRangeIntegrationTest1 (k, v) VALUES ('[2010-12-03 TO 2010-12-04]', 1)", "INSERT INTO dateRangeIntegrationTest1 (k, v) VALUES ('[2015-12-03T10:15:30.001Z TO 2016-01-01T00:05:11.967Z]', 2)");
        ResultSet results = this.session().execute("SELECT * FROM dateRangeIntegrationTest1");
        List rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(2);
        Assertions.assertThat((Object)((Row)rows.get(0)).get("k", DateRange.class)).isEqualTo((Object)DateRange.parse((String)"[2010-12-03 TO 2010-12-04]"));
        Assertions.assertThat((Object)((Row)rows.get(1)).get("k", DateRange.class)).isEqualTo((Object)DateRange.parse((String)"[2015-12-03T10:15:30.001Z TO 2016-01-01T00:05:11.967Z]"));
        results = this.session().execute("SELECT * FROM dateRangeIntegrationTest1 WHERE k = '[2015-12-03T10:15:30.001Z TO 2016-01-01T00:05:11.967]'");
        rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Assertions.assertThat((int)((Row)rows.get(0)).getInt("v")).isEqualTo(2);
        results = this.session().execute("SELECT * FROM dateRangeIntegrationTest1");
        rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(2);
        Assertions.assertThat((Object)((Row)rows.get(1)).get("k", DateRange.class)).isEqualTo((Object)DateRange.parse((String)"[2015-12-03T10:15:30.001Z TO 2016-01-01T00:05:11.967Z]"));
    }

    @Test(groups={"short"})
    public void should_store_date_range() throws Exception {
        this.execute("CREATE TABLE dateRangeIntegrationTest2 (k int PRIMARY KEY, v 'DateRangeType')", "INSERT INTO dateRangeIntegrationTest2 (k, v) VALUES (1, '[2000-01-01T10:15:30.301Z TO *]')", "INSERT INTO dateRangeIntegrationTest2 (k, v) VALUES (2, '[2000-02 TO 2000-03]')", "INSERT INTO dateRangeIntegrationTest2 (k, v) VALUES (3, '[* TO 2020]')", "INSERT INTO dateRangeIntegrationTest2 (k, v) VALUES (4, null)", "INSERT INTO dateRangeIntegrationTest2 (k)    VALUES (5)", "INSERT INTO dateRangeIntegrationTest2 (k, v) VALUES (6, '*')");
        ResultSet results = this.session().execute("SELECT * FROM dateRangeIntegrationTest2");
        List rows = results.all();
        Assertions.assertThat((List)rows).extracting((Extractor)new Extractor<Row, DateRange>(){

            public DateRange extract(Row input) {
                return (DateRange)input.get("v", DateRange.class);
            }
        }).containsOnly((Object[])new DateRange[]{DateRange.parse((String)"[2000-01-01T10:15:30.301Z TO *]"), DateRange.parse((String)"[2000-02 TO 2000-03]"), DateRange.parse((String)"[* TO 2020]"), null, DateRange.parse((String)"*")});
    }

    @Test(groups={"short"})
    public void should_disallow_invalid_order() throws Exception {
        this.session().execute("CREATE TABLE dateRangeIntegrationTest3 (k int PRIMARY KEY, v 'DateRangeType')");
        try {
            this.session().execute("INSERT INTO dateRangeIntegrationTest3 (k, v) VALUES (1, '[2020-01-01T10:15:30.009Z TO 2010-01-01T00:05:11.031Z]')");
            Assertions.fail((String)"Expected InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Wrong order: 2020-01-01T10:15:30.009Z TO 2010-01-01T00:05:11.031Z"}).contains(new CharSequence[]{"Could not parse date range: [2020-01-01T10:15:30.009Z TO 2010-01-01T00:05:11.031Z]"});
        }
    }

    @Test(groups={"short"})
    public void should_allow_date_range_in_udt_and_tuple() throws Exception {
        this.execute("CREATE TYPE IF NOT EXISTS test_udt (i int, range 'DateRangeType')", "CREATE TABLE dateRangeIntegrationTest4 (k int PRIMARY KEY, u test_udt, uf frozen<test_udt>, t tuple<'DateRangeType', int>, tf frozen<tuple<'DateRangeType', int>>)", "INSERT INTO dateRangeIntegrationTest4 (k, u, uf, t, tf) VALUES (1, {i: 10, range: '[2000-01-01T10:15:30.003Z TO 2020-01-01T10:15:30.001Z]'}, {i: 20, range: '[2000-01-01T10:15:30.003Z TO 2020-01-01T10:15:30.001Z]'}, ('[2000-01-01T10:15:30.003Z TO 2020-01-01T10:15:30.001Z]', 30), ('[2000-01-01T10:15:30.003Z TO 2020-01-01T10:15:30.001Z]', 40))");
        DateRange expected = DateRange.parse((String)"[2000-01-01T10:15:30.003Z TO 2020-01-01T10:15:30.001Z]");
        ResultSet results = this.session().execute("SELECT * FROM dateRangeIntegrationTest4");
        List rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        UDTValue u = (UDTValue)((Row)rows.get(0)).get("u", UDTValue.class);
        DateRange dateRange = (DateRange)u.get("range", DateRange.class);
        Assertions.assertThat((Object)dateRange).isEqualTo((Object)expected);
        Assertions.assertThat((int)u.getInt("i")).isEqualTo(10);
        u = (UDTValue)((Row)rows.get(0)).get("uf", UDTValue.class);
        dateRange = (DateRange)u.get("range", DateRange.class);
        Assertions.assertThat((Object)dateRange).isEqualTo((Object)expected);
        Assertions.assertThat((int)u.getInt("i")).isEqualTo(20);
        TupleValue t = (TupleValue)((Row)rows.get(0)).get("t", TupleValue.class);
        dateRange = (DateRange)t.get(0, DateRange.class);
        Assertions.assertThat((Object)dateRange).isEqualTo((Object)expected);
        Assertions.assertThat((int)t.getInt(1)).isEqualTo(30);
        t = (TupleValue)((Row)rows.get(0)).get("tf", TupleValue.class);
        dateRange = (DateRange)t.get(0, DateRange.class);
        Assertions.assertThat((Object)dateRange).isEqualTo((Object)expected);
        Assertions.assertThat((int)t.getInt(1)).isEqualTo(40);
    }

    @Test(groups={"short"})
    public void should_allow_date_range_in_collections() throws Exception {
        this.execute("CREATE TABLE dateRangeIntegrationTest5 (k int PRIMARY KEY, l list<'DateRangeType'>, s set<'DateRangeType'>, dr2i map<'DateRangeType', int>, i2dr map<int, 'DateRangeType'>)", "INSERT INTO dateRangeIntegrationTest5 (k, l, s, i2dr, dr2i) VALUES (1, ['[2000-01-01T10:15:30.001Z TO 2020]', '[2010-01-01T10:15:30.001Z TO 2020]', '2001-01-02'], {'[2000-01-01T10:15:30.001Z TO 2020]', '[2000-01-01T10:15:30.001Z TO 2020]', '[2010-01-01T10:15:30.001Z TO 2020]'}, {1: '[2000-01-01T10:15:30.001Z TO 2020]', 2: '[2010-01-01T10:15:30.001Z TO 2020]'}, {'[2000-01-01T10:15:30.001Z TO 2020]': 1, '[2010-01-01T10:15:30.001Z TO 2020]': 2})");
        ResultSet results = this.session().execute("SELECT * FROM dateRangeIntegrationTest5");
        List rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        List drList = ((Row)rows.get(0)).getList("l", DateRange.class);
        Assertions.assertThat((int)drList.size()).isEqualTo(3);
        Assertions.assertThat(drList.get(0)).isEqualTo((Object)DateRange.parse((String)"[2000-01-01T10:15:30.001Z TO 2020]"));
        Assertions.assertThat(drList.get(1)).isEqualTo((Object)DateRange.parse((String)"[2010-01-01T10:15:30.001Z TO 2020]"));
        Assertions.assertThat(drList.get(2)).isEqualTo((Object)DateRange.parse((String)"2001-01-02"));
        Set drSet = ((Row)rows.get(0)).getSet("s", DateRange.class);
        Assertions.assertThat((int)drSet.size()).isEqualTo(2);
        Assertions.assertThat((Iterable)drSet).isEqualTo((Object)Sets.newHashSet((Object[])new DateRange[]{DateRange.parse((String)"[2000-01-01T10:15:30.001Z TO 2020]"), DateRange.parse((String)"[2010-01-01T10:15:30.001Z TO 2020]")}));
        Map dr2i = ((Row)rows.get(0)).getMap("dr2i", DateRange.class, Integer.class);
        Assertions.assertThat((int)dr2i.size()).isEqualTo(2);
        Assertions.assertThat((int)((Integer)dr2i.get(DateRange.parse((String)"[2000-01-01T10:15:30.001Z TO 2020]")))).isEqualTo(1);
        Assertions.assertThat((int)((Integer)dr2i.get(DateRange.parse((String)"[2010-01-01T10:15:30.001Z TO 2020]")))).isEqualTo(2);
        Map i2dr = ((Row)rows.get(0)).getMap("i2dr", Integer.class, DateRange.class);
        Assertions.assertThat((int)i2dr.size()).isEqualTo(2);
        Assertions.assertThat(i2dr.get(1)).isEqualTo((Object)DateRange.parse((String)"[2000-01-01T10:15:30.001Z TO 2020]"));
        Assertions.assertThat(i2dr.get(2)).isEqualTo((Object)DateRange.parse((String)"[2010-01-01T10:15:30.001Z TO 2020]"));
    }

    @Test(groups={"short"})
    public void should_allow_date_range_in_prepared_statement_parameter() throws Exception {
        this.session().execute("CREATE TABLE dateRangeIntegrationTest6 (k int PRIMARY KEY, v 'DateRangeType')");
        PreparedStatement statement = this.session().prepare("INSERT INTO dateRangeIntegrationTest6 (k,v) VALUES(?,?)");
        DateRange expected = DateRange.parse((String)"[2007-12-03 TO 2007-12]");
        this.session().execute((Statement)statement.bind(new Object[]{1, expected}));
        ResultSet results = this.session().execute("SELECT * FROM dateRangeIntegrationTest6");
        List rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        DateRange actual = (DateRange)((Row)rows.get(0)).get("v", DateRange.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((Comparable)actual.getLowerBound().getPrecision()).isEqualTo((Object)DateRange.DateRangeBound.Precision.DAY);
        Assertions.assertThat((Comparable)actual.getUpperBound().getPrecision()).isEqualTo((Object)DateRange.DateRangeBound.Precision.MONTH);
        Assertions.assertThat((String)actual.toString()).isEqualTo((Object)"[2007-12-03 TO 2007-12]");
        expected = DateRange.parse((String)"[* TO *]");
        this.session().execute((Statement)statement.bind(new Object[]{1, expected}));
        results = this.session().execute("SELECT * FROM dateRangeIntegrationTest6");
        rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        actual = (DateRange)((Row)rows.get(0)).get("v", DateRange.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((boolean)actual.getLowerBound().isUnbounded()).isTrue();
        Assertions.assertThat((boolean)actual.isSingleBounded()).isFalse();
        Assertions.assertThat((boolean)actual.getUpperBound().isUnbounded()).isTrue();
        Assertions.assertThat((String)actual.toString()).isEqualTo((Object)"[* TO *]");
        expected = DateRange.parse((String)"*");
        this.session().execute((Statement)statement.bind(new Object[]{1, expected}));
        results = this.session().execute("SELECT * FROM dateRangeIntegrationTest6");
        rows = results.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        actual = (DateRange)((Row)rows.get(0)).get("v", DateRange.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((boolean)actual.getLowerBound().isUnbounded()).isTrue();
        Assertions.assertThat((boolean)actual.isSingleBounded()).isTrue();
        Assertions.assertThat((String)actual.toString()).isEqualTo((Object)"*");
    }

    @Test(groups={"short"})
    public void should_select_date_range_using_json() throws Exception {
        this.session().execute("CREATE TABLE dateRangeIntegrationTest7 (k int PRIMARY KEY, v 'DateRangeType')");
        PreparedStatement statement = this.session().prepare("INSERT INTO dateRangeIntegrationTest7 (k,v) VALUES(?,?)");
        DateRange expected = DateRange.parse((String)"[2007-12-03 TO 2007-12]");
        this.session().execute((Statement)statement.bind(new Object[]{1, expected}));
        ResultSet results = this.session().execute("SELECT JSON * FROM dateRangeIntegrationTest7");
        List rows = results.all();
        Assertions.assertThat((String)((Row)rows.get(0)).getString(0)).isEqualTo((Object)"{\"k\": 1, \"v\": \"[2007-12-03 TO 2007-12]\"}");
        expected = DateRange.parse((String)"[* TO *]");
        this.session().execute((Statement)statement.bind(new Object[]{1, expected}));
        results = this.session().execute("SELECT JSON * FROM dateRangeIntegrationTest7");
        rows = results.all();
        Assertions.assertThat((String)((Row)rows.get(0)).getString(0)).isEqualTo((Object)"{\"k\": 1, \"v\": \"[* TO *]\"}");
        expected = DateRange.parse((String)"*");
        this.session().execute((Statement)statement.bind(new Object[]{1, expected}));
        results = this.session().execute("SELECT JSON * FROM dateRangeIntegrationTest7");
        rows = results.all();
        Assertions.assertThat((String)((Row)rows.get(0)).getString(0)).isEqualTo((Object)"{\"k\": 1, \"v\": \"*\"}");
    }
}

