/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.Statement;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import java.nio.ByteBuffer;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class SimpleGraphStatementTest {
    private static final String PROXY_EXECUTE = "ProxyExecute";

    @Test(groups={"unit"})
    public void should_retain_executeAs_payload_when_unwrapped() throws Exception {
        GraphStatement graphStatement = new SimpleGraphStatement("g.V()").executingAs("tom");
        Statement statement = graphStatement.unwrap(new GraphOptions().setGraphSubProtocol(GraphProtocol.GRAPHSON_1_0));
        Map payload = statement.getOutgoingPayload();
        Assertions.assertThat((boolean)payload.containsKey(PROXY_EXECUTE));
        Assertions.assertThat((String)new String(((ByteBuffer)payload.get(PROXY_EXECUTE)).array(), "UTF-8")).isEqualTo((Object)"tom");
    }
}

