/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.driver.dse.graph.Vertex;
import java.util.Map;
import org.assertj.core.api.Assertions;

public class GraphSONOptionsTestUtils {
    public static void assertGraphSON1Result(GraphNode graphNode) {
        Assertions.assertThat(graphNode.getClass()).isEqualTo(DefaultGraphNode.class);
        Assertions.assertThat((String)graphNode.asVertex().getProperty("name").getValue().asString()).isEqualTo((Object)"marko");
        Assertions.assertThat((Object)graphNode.as(Object.class)).isInstanceOf(Map.class);
    }

    public static void assertGraphSON2Result(GraphNode graphNode) {
        Assertions.assertThat(graphNode.getClass()).isEqualTo(ObjectGraphNode.class);
        Assertions.assertThat((String)graphNode.asVertex().getProperty("name").getValue().asString()).isEqualTo((Object)"marko");
        Assertions.assertThat((Object)graphNode.as(Object.class)).isInstanceOf(Vertex.class);
    }

    public static void assertLogContainsGraphSON1Warning(MemoryAppender logs) {
        Assertions.assertThat((String)logs.getNext()).contains(new CharSequence[]{"GraphSON1 is being used for a graph query"});
    }

    public static void assertLogDoesNotContainGraphSON1Warning(MemoryAppender logs) {
        Assertions.assertThat((String)logs.getNext()).isEmpty();
    }
}

